<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceptaIWynikWeryfikacjiMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Recepta, jej status oraz wynik weryfikacji w chwili zapisywania recepty.
 * @subpackage Structs
 */
class ReceptaIWynikWeryfikacjiMT extends AbstractStructBase
{
    /**
     * The statusRecepty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusRecepty;
    /**
     * The weryfikowanyDokument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var WeryfikowanaReceptaMT
     */
    public $weryfikowanyDokument;
    /**
     * The recepta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var ReceptaMT
     */
    public $recepta;
    /**
     * The przyczynaZablokowaniaRecepty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $przyczynaZablokowaniaRecepty;
    /**
     * The dokumentRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DokumentRealizacjiReceptyMT[]
     */
    public $dokumentRealizacjiRecepty;
    /**
     * The dokumentAnulowaniaRecepty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DokumentAnulowaniaReceptyMT
     */
    public $dokumentAnulowaniaRecepty;
    /**
     * Constructor method for ReceptaIWynikWeryfikacjiMT
     * @uses ReceptaIWynikWeryfikacjiMT::setStatusRecepty()
     * @uses ReceptaIWynikWeryfikacjiMT::setWeryfikowanyDokument()
     * @uses ReceptaIWynikWeryfikacjiMT::setRecepta()
     * @uses ReceptaIWynikWeryfikacjiMT::setPrzyczynaZablokowaniaRecepty()
     * @uses ReceptaIWynikWeryfikacjiMT::setDokumentRealizacjiRecepty()
     * @uses ReceptaIWynikWeryfikacjiMT::setDokumentAnulowaniaRecepty()
     * @param string $statusRecepty
     * @param WeryfikowanaReceptaMT $weryfikowanyDokument
     * @param ReceptaMT $recepta
     * @param string $przyczynaZablokowaniaRecepty
     * @param DokumentRealizacjiReceptyMT[] $dokumentRealizacjiRecepty
     * @param DokumentAnulowaniaReceptyMT $dokumentAnulowaniaRecepty
     */
    public function __construct($statusRecepty = null, WeryfikowanaReceptaMT $weryfikowanyDokument = null, ReceptaMT $recepta = null, $przyczynaZablokowaniaRecepty = null, array $dokumentRealizacjiRecepty = array(), DokumentAnulowaniaReceptyMT $dokumentAnulowaniaRecepty = null)
    {
        $this
            ->setStatusRecepty($statusRecepty)
            ->setWeryfikowanyDokument($weryfikowanyDokument)
            ->setRecepta($recepta)
            ->setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty)
            ->setDokumentRealizacjiRecepty($dokumentRealizacjiRecepty)
            ->setDokumentAnulowaniaRecepty($dokumentAnulowaniaRecepty);
    }
    /**
     * Get statusRecepty value
     * @return string
     */
    public function getStatusRecepty()
    {
        return $this->statusRecepty;
    }
    /**
     * Set statusRecepty value
     * @uses StatusReceptyEnumMT::valueIsValid()
     * @uses StatusReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusRecepty
     * @return ReceptaIWynikWeryfikacjiMT
     */
    public function setStatusRecepty($statusRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusReceptyEnumMT::valueIsValid($statusRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusReceptyEnumMT', is_array($statusRecepty) ? implode(', ', $statusRecepty) : var_export($statusRecepty, true), implode(', ', StatusReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusRecepty = $statusRecepty;
        return $this;
    }
    /**
     * Get weryfikowanyDokument value
     * @return WeryfikowanaReceptaMT
     */
    public function getWeryfikowanyDokument()
    {
        return $this->weryfikowanyDokument;
    }
    /**
     * Set weryfikowanyDokument value
     * @param WeryfikowanaReceptaMT $weryfikowanyDokument
     * @return ReceptaIWynikWeryfikacjiMT
     */
    public function setWeryfikowanyDokument(WeryfikowanaReceptaMT $weryfikowanyDokument = null)
    {
        $this->weryfikowanyDokument = $weryfikowanyDokument;
        return $this;
    }
    /**
     * Get recepta value
     * @return ReceptaMT
     */
    public function getRecepta()
    {
        return $this->recepta;
    }
    /**
     * Set recepta value
     * @param ReceptaMT $recepta
     * @return ReceptaIWynikWeryfikacjiMT
     */
    public function setRecepta(ReceptaMT $recepta = null)
    {
        $this->recepta = $recepta;
        return $this;
    }
    /**
     * Get przyczynaZablokowaniaRecepty value
     * @return string|null
     */
    public function getPrzyczynaZablokowaniaRecepty()
    {
        return $this->przyczynaZablokowaniaRecepty;
    }
    /**
     * Set przyczynaZablokowaniaRecepty value
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid()
     * @uses PrzyczynaZablokowaniaReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $przyczynaZablokowaniaRecepty
     * @return ReceptaIWynikWeryfikacjiMT
     */
    public function setPrzyczynaZablokowaniaRecepty($przyczynaZablokowaniaRecepty = null)
    {
        // validation for constraint: enumeration
        if (!PrzyczynaZablokowaniaReceptyEnumMT::valueIsValid($przyczynaZablokowaniaRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PrzyczynaZablokowaniaReceptyEnumMT', is_array($przyczynaZablokowaniaRecepty) ? implode(', ', $przyczynaZablokowaniaRecepty) : var_export($przyczynaZablokowaniaRecepty, true), implode(', ', PrzyczynaZablokowaniaReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->przyczynaZablokowaniaRecepty = $przyczynaZablokowaniaRecepty;
        return $this;
    }
    /**
     * Get dokumentRealizacjiRecepty value
     * @return DokumentRealizacjiReceptyMT[]|null
     */
    public function getDokumentRealizacjiRecepty()
    {
        return $this->dokumentRealizacjiRecepty;
    }
    /**
     * This method is responsible for validating the values passed to the setDokumentRealizacjiRecepty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDokumentRealizacjiRecepty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDokumentRealizacjiReceptyForArrayConstraintsFromSetDokumentRealizacjiRecepty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receptaIWynikWeryfikacjiMTDokumentRealizacjiReceptyItem) {
            // validation for constraint: itemType
            if (!$receptaIWynikWeryfikacjiMTDokumentRealizacjiReceptyItem instanceof DokumentRealizacjiReceptyMT) {
                $invalidValues[] = is_object($receptaIWynikWeryfikacjiMTDokumentRealizacjiReceptyItem) ? get_class($receptaIWynikWeryfikacjiMTDokumentRealizacjiReceptyItem) : sprintf('%s(%s)', gettype($receptaIWynikWeryfikacjiMTDokumentRealizacjiReceptyItem), var_export($receptaIWynikWeryfikacjiMTDokumentRealizacjiReceptyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dokumentRealizacjiRecepty property can only contain items of type DokumentRealizacjiReceptyMT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dokumentRealizacjiRecepty value
     * @throws \InvalidArgumentException
     * @param DokumentRealizacjiReceptyMT[] $dokumentRealizacjiRecepty
     * @return ReceptaIWynikWeryfikacjiMT
     */
    public function setDokumentRealizacjiRecepty(array $dokumentRealizacjiRecepty = array())
    {
        // validation for constraint: array
        if ('' !== ($dokumentRealizacjiReceptyArrayErrorMessage = self::validateDokumentRealizacjiReceptyForArrayConstraintsFromSetDokumentRealizacjiRecepty($dokumentRealizacjiRecepty))) {
            throw new \InvalidArgumentException($dokumentRealizacjiReceptyArrayErrorMessage, __LINE__);
        }
        $this->dokumentRealizacjiRecepty = $dokumentRealizacjiRecepty;
        return $this;
    }
    /**
     * Add item to dokumentRealizacjiRecepty value
     * @throws \InvalidArgumentException
     * @param DokumentRealizacjiReceptyMT $item
     * @return ReceptaIWynikWeryfikacjiMT
     */
    public function addToDokumentRealizacjiRecepty(DokumentRealizacjiReceptyMT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DokumentRealizacjiReceptyMT) {
            throw new \InvalidArgumentException(sprintf('The dokumentRealizacjiRecepty property can only contain items of type DokumentRealizacjiReceptyMT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dokumentRealizacjiRecepty[] = $item;
        return $this;
    }
    /**
     * Get dokumentAnulowaniaRecepty value
     * @return DokumentAnulowaniaReceptyMT|null
     */
    public function getDokumentAnulowaniaRecepty()
    {
        return $this->dokumentAnulowaniaRecepty;
    }
    /**
     * Set dokumentAnulowaniaRecepty value
     * @param DokumentAnulowaniaReceptyMT $dokumentAnulowaniaRecepty
     * @return ReceptaIWynikWeryfikacjiMT
     */
    public function setDokumentAnulowaniaRecepty(DokumentAnulowaniaReceptyMT $dokumentAnulowaniaRecepty = null)
    {
        $this->dokumentAnulowaniaRecepty = $dokumentAnulowaniaRecepty;
        return $this;
    }
}
