<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Przyjecie ServiceType
 * @subpackage Services
 */
class Przyjecie extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20170510', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * przyjecieDoRealizacjiReceptyNaLekRecepturowy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20170510
     * - SOAPHeaderTypes: KontekstMT
     * - SOAPHeaders: required
     * - documentation: Przyjęcie do realizacji recepty na lek recepturowy. Parametrem wejściowym jest klucz recepty elektronicznej albo numer recepty papierowej i pozycja na recepcie papierowej. Operacja blokuje w systemie daną receptę do realizacji
     * (zmienia statusu recepty z Wystawiona na Zablokowana).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param PrzyjecieDoRealizacjiReceptyNaLekRecepturowyRequest $przyjecieDoRealizacjiReceptyNaLekRecepturowy
     * @return PrzyjecieDoRealizacjiReceptyNaLekRecepturowyResponse|bool
     */
    public function przyjecieDoRealizacjiReceptyNaLekRecepturowy(PrzyjecieDoRealizacjiReceptyNaLekRecepturowyRequest $przyjecieDoRealizacjiReceptyNaLekRecepturowy)
    {
        try {
            $this->setResult($this->getSoapClient()->przyjecieDoRealizacjiReceptyNaLekRecepturowy($przyjecieDoRealizacjiReceptyNaLekRecepturowy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return PrzyjecieDoRealizacjiReceptyNaLekRecepturowyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
