<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KryteriaWyszukiwaniaReceptMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Kryteria wyszukiwania recept.
 * @subpackage Structs
 */
class KryteriaWyszukiwaniaReceptMT extends AbstractStructBase
{
    /**
     * The dataWystawieniaReceptyDo
     * Meta information extracted from the WSDL
     * - documentation: Górne ograniczenie daty wystawienia recepty - data do kiedy wystawione mają być poszukiwane recepty. Wartość w tym polu musi być nie mniejsza niż data podana w dolnym ograniczeniu daty wystawienia recepty (o ile podano dolne
     * ograniczenie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaReceptyDo;
    /**
     * The dataWystawieniaReceptyOd
     * Meta information extracted from the WSDL
     * - documentation: Dolne ograniczenie daty wystawienia recepty - data od kiedy wystawione mają być poszukiwane recepty. Wartość w tym polu musi być nie większa niż data podana w górnym ograniczeniu daty wystawienia recepty (o ile podano górne
     * ograniczenie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaReceptyOd;
    /**
     * The idPracownikaMedycznego
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator pracownika medycznego, który wystawił receptę.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var IdentyfikatorPracownikaMedycznegoOIDMT
     */
    public $idPracownikaMedycznego;
    /**
     * The idUslugobiorcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator usługobiorcy, dla którego została wystawiona recepta.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var IdentyfikatorUslugobiorcyOIDMT
     */
    public $idUslugobiorcy;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty nadany przez usługodawcę wystawiającego receptę.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * The statusRecepty
     * Meta information extracted from the WSDL
     * - documentation: Status recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusRecepty;
    /**
     * Constructor method for KryteriaWyszukiwaniaReceptMT
     * @uses KryteriaWyszukiwaniaReceptMT::setDataWystawieniaReceptyDo()
     * @uses KryteriaWyszukiwaniaReceptMT::setDataWystawieniaReceptyOd()
     * @uses KryteriaWyszukiwaniaReceptMT::setIdPracownikaMedycznego()
     * @uses KryteriaWyszukiwaniaReceptMT::setIdUslugobiorcy()
     * @uses KryteriaWyszukiwaniaReceptMT::setNumerRecepty()
     * @uses KryteriaWyszukiwaniaReceptMT::setStatusRecepty()
     * @param string $dataWystawieniaReceptyDo
     * @param string $dataWystawieniaReceptyOd
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $idPracownikaMedycznego
     * @param IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy
     * @param NumerReceptyOIDMT $numerRecepty
     * @param string $statusRecepty
     */
    public function __construct($dataWystawieniaReceptyDo = null, $dataWystawieniaReceptyOd = null, IdentyfikatorPracownikaMedycznegoOIDMT $idPracownikaMedycznego = null, IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy = null, NumerReceptyOIDMT $numerRecepty = null, $statusRecepty = null)
    {
        $this
            ->setDataWystawieniaReceptyDo($dataWystawieniaReceptyDo)
            ->setDataWystawieniaReceptyOd($dataWystawieniaReceptyOd)
            ->setIdPracownikaMedycznego($idPracownikaMedycznego)
            ->setIdUslugobiorcy($idUslugobiorcy)
            ->setNumerRecepty($numerRecepty)
            ->setStatusRecepty($statusRecepty);
    }
    /**
     * Get dataWystawieniaReceptyDo value
     * @return string|null
     */
    public function getDataWystawieniaReceptyDo()
    {
        return $this->dataWystawieniaReceptyDo;
    }
    /**
     * Set dataWystawieniaReceptyDo value
     * @param string $dataWystawieniaReceptyDo
     * @return KryteriaWyszukiwaniaReceptMT
     */
    public function setDataWystawieniaReceptyDo($dataWystawieniaReceptyDo = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaReceptyDo) && !is_string($dataWystawieniaReceptyDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaReceptyDo, true), gettype($dataWystawieniaReceptyDo)), __LINE__);
        }
        $this->dataWystawieniaReceptyDo = $dataWystawieniaReceptyDo;
        return $this;
    }
    /**
     * Get dataWystawieniaReceptyOd value
     * @return string|null
     */
    public function getDataWystawieniaReceptyOd()
    {
        return $this->dataWystawieniaReceptyOd;
    }
    /**
     * Set dataWystawieniaReceptyOd value
     * @param string $dataWystawieniaReceptyOd
     * @return KryteriaWyszukiwaniaReceptMT
     */
    public function setDataWystawieniaReceptyOd($dataWystawieniaReceptyOd = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaReceptyOd) && !is_string($dataWystawieniaReceptyOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaReceptyOd, true), gettype($dataWystawieniaReceptyOd)), __LINE__);
        }
        $this->dataWystawieniaReceptyOd = $dataWystawieniaReceptyOd;
        return $this;
    }
    /**
     * Get idPracownikaMedycznego value
     * @return IdentyfikatorPracownikaMedycznegoOIDMT|null
     */
    public function getIdPracownikaMedycznego()
    {
        return $this->idPracownikaMedycznego;
    }
    /**
     * Set idPracownikaMedycznego value
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $idPracownikaMedycznego
     * @return KryteriaWyszukiwaniaReceptMT
     */
    public function setIdPracownikaMedycznego(IdentyfikatorPracownikaMedycznegoOIDMT $idPracownikaMedycznego = null)
    {
        $this->idPracownikaMedycznego = $idPracownikaMedycznego;
        return $this;
    }
    /**
     * Get idUslugobiorcy value
     * @return IdentyfikatorUslugobiorcyOIDMT|null
     */
    public function getIdUslugobiorcy()
    {
        return $this->idUslugobiorcy;
    }
    /**
     * Set idUslugobiorcy value
     * @param IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy
     * @return KryteriaWyszukiwaniaReceptMT
     */
    public function setIdUslugobiorcy(IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy = null)
    {
        $this->idUslugobiorcy = $idUslugobiorcy;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT|null
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return KryteriaWyszukiwaniaReceptMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
    /**
     * Get statusRecepty value
     * @return string|null
     */
    public function getStatusRecepty()
    {
        return $this->statusRecepty;
    }
    /**
     * Set statusRecepty value
     * @uses StatusReceptyEnumMT::valueIsValid()
     * @uses StatusReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusRecepty
     * @return KryteriaWyszukiwaniaReceptMT
     */
    public function setStatusRecepty($statusRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusReceptyEnumMT::valueIsValid($statusRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusReceptyEnumMT', is_array($statusRecepty) ? implode(', ', $statusRecepty) : var_export($statusRecepty, true), implode(', ', StatusReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusRecepty = $statusRecepty;
        return $this;
    }
}
