<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KryteriaWyszukiwaniaDokumentowRealizacjiMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Kryteria wyszukiwania dokumentów realizacji recept.
 * @subpackage Structs
 */
class KryteriaWyszukiwaniaDokumentowRealizacjiMT extends AbstractStructBase
{
    /**
     * The identyfikatorPodmiotuWystawcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator wystawcy dokumentu recepty, dla którego dana apteka wystawiła dokument realizacji.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var IdentyfikatorUslugodawcyOIDMT
     */
    public $identyfikatorPodmiotuWystawcy;
    /**
     * The dataWystawieniaOd
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu realizacji (od).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaOd;
    /**
     * The dataWystawieniaDo
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu realizacji (do).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaDo;
    /**
     * The identyfikatorPracownikaRealizatora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator pracownika (farmaceuta, technik farmaceuta) podmiotu realizatora odpowiedzialnego za wystawienie dokumentu realizacji recepty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var IdentyfikatorPracownikaMedycznegoOIDMT
     */
    public $identyfikatorPracownikaRealizatora;
    /**
     * The rodzajRealizacji
     * Meta information extracted from the WSDL
     * - documentation: Rodzaj realizacji.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rodzajRealizacji;
    /**
     * The statusDokumentuRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Status dokumentu realizacji recepty
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusDokumentuRealizacjiRecepty;
    /**
     * Constructor method for KryteriaWyszukiwaniaDokumentowRealizacjiMT
     * @uses KryteriaWyszukiwaniaDokumentowRealizacjiMT::setIdentyfikatorPodmiotuWystawcy()
     * @uses KryteriaWyszukiwaniaDokumentowRealizacjiMT::setDataWystawieniaOd()
     * @uses KryteriaWyszukiwaniaDokumentowRealizacjiMT::setDataWystawieniaDo()
     * @uses KryteriaWyszukiwaniaDokumentowRealizacjiMT::setIdentyfikatorPracownikaRealizatora()
     * @uses KryteriaWyszukiwaniaDokumentowRealizacjiMT::setRodzajRealizacji()
     * @uses KryteriaWyszukiwaniaDokumentowRealizacjiMT::setStatusDokumentuRealizacjiRecepty()
     * @param IdentyfikatorUslugodawcyOIDMT $identyfikatorPodmiotuWystawcy
     * @param string $dataWystawieniaOd
     * @param string $dataWystawieniaDo
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaRealizatora
     * @param string $rodzajRealizacji
     * @param string $statusDokumentuRealizacjiRecepty
     */
    public function __construct(IdentyfikatorUslugodawcyOIDMT $identyfikatorPodmiotuWystawcy = null, $dataWystawieniaOd = null, $dataWystawieniaDo = null, IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaRealizatora = null, $rodzajRealizacji = null, $statusDokumentuRealizacjiRecepty = null)
    {
        $this
            ->setIdentyfikatorPodmiotuWystawcy($identyfikatorPodmiotuWystawcy)
            ->setDataWystawieniaOd($dataWystawieniaOd)
            ->setDataWystawieniaDo($dataWystawieniaDo)
            ->setIdentyfikatorPracownikaRealizatora($identyfikatorPracownikaRealizatora)
            ->setRodzajRealizacji($rodzajRealizacji)
            ->setStatusDokumentuRealizacjiRecepty($statusDokumentuRealizacjiRecepty);
    }
    /**
     * Get identyfikatorPodmiotuWystawcy value
     * @return IdentyfikatorUslugodawcyOIDMT|null
     */
    public function getIdentyfikatorPodmiotuWystawcy()
    {
        return $this->identyfikatorPodmiotuWystawcy;
    }
    /**
     * Set identyfikatorPodmiotuWystawcy value
     * @param IdentyfikatorUslugodawcyOIDMT $identyfikatorPodmiotuWystawcy
     * @return KryteriaWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setIdentyfikatorPodmiotuWystawcy(IdentyfikatorUslugodawcyOIDMT $identyfikatorPodmiotuWystawcy = null)
    {
        $this->identyfikatorPodmiotuWystawcy = $identyfikatorPodmiotuWystawcy;
        return $this;
    }
    /**
     * Get dataWystawieniaOd value
     * @return string|null
     */
    public function getDataWystawieniaOd()
    {
        return $this->dataWystawieniaOd;
    }
    /**
     * Set dataWystawieniaOd value
     * @param string $dataWystawieniaOd
     * @return KryteriaWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setDataWystawieniaOd($dataWystawieniaOd = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaOd) && !is_string($dataWystawieniaOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaOd, true), gettype($dataWystawieniaOd)), __LINE__);
        }
        $this->dataWystawieniaOd = $dataWystawieniaOd;
        return $this;
    }
    /**
     * Get dataWystawieniaDo value
     * @return string|null
     */
    public function getDataWystawieniaDo()
    {
        return $this->dataWystawieniaDo;
    }
    /**
     * Set dataWystawieniaDo value
     * @param string $dataWystawieniaDo
     * @return KryteriaWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setDataWystawieniaDo($dataWystawieniaDo = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaDo) && !is_string($dataWystawieniaDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaDo, true), gettype($dataWystawieniaDo)), __LINE__);
        }
        $this->dataWystawieniaDo = $dataWystawieniaDo;
        return $this;
    }
    /**
     * Get identyfikatorPracownikaRealizatora value
     * @return IdentyfikatorPracownikaMedycznegoOIDMT|null
     */
    public function getIdentyfikatorPracownikaRealizatora()
    {
        return $this->identyfikatorPracownikaRealizatora;
    }
    /**
     * Set identyfikatorPracownikaRealizatora value
     * @param IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaRealizatora
     * @return KryteriaWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setIdentyfikatorPracownikaRealizatora(IdentyfikatorPracownikaMedycznegoOIDMT $identyfikatorPracownikaRealizatora = null)
    {
        $this->identyfikatorPracownikaRealizatora = $identyfikatorPracownikaRealizatora;
        return $this;
    }
    /**
     * Get rodzajRealizacji value
     * @return string|null
     */
    public function getRodzajRealizacji()
    {
        return $this->rodzajRealizacji;
    }
    /**
     * Set rodzajRealizacji value
     * @uses RodzajRealizacjiEnumMT::valueIsValid()
     * @uses RodzajRealizacjiEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rodzajRealizacji
     * @return KryteriaWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setRodzajRealizacji($rodzajRealizacji = null)
    {
        // validation for constraint: enumeration
        if (!RodzajRealizacjiEnumMT::valueIsValid($rodzajRealizacji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class RodzajRealizacjiEnumMT', is_array($rodzajRealizacji) ? implode(', ', $rodzajRealizacji) : var_export($rodzajRealizacji, true), implode(', ', RodzajRealizacjiEnumMT::getValidValues())), __LINE__);
        }
        $this->rodzajRealizacji = $rodzajRealizacji;
        return $this;
    }
    /**
     * Get statusDokumentuRealizacjiRecepty value
     * @return string|null
     */
    public function getStatusDokumentuRealizacjiRecepty()
    {
        return $this->statusDokumentuRealizacjiRecepty;
    }
    /**
     * Set statusDokumentuRealizacjiRecepty value
     * @uses StatusDokumentuRealizacjiReceptyEnumMT::valueIsValid()
     * @uses StatusDokumentuRealizacjiReceptyEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusDokumentuRealizacjiRecepty
     * @return KryteriaWyszukiwaniaDokumentowRealizacjiMT
     */
    public function setStatusDokumentuRealizacjiRecepty($statusDokumentuRealizacjiRecepty = null)
    {
        // validation for constraint: enumeration
        if (!StatusDokumentuRealizacjiReceptyEnumMT::valueIsValid($statusDokumentuRealizacjiRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class StatusDokumentuRealizacjiReceptyEnumMT', is_array($statusDokumentuRealizacjiRecepty) ? implode(', ', $statusDokumentuRealizacjiRecepty) : var_export($statusDokumentuRealizacjiRecepty, true), implode(', ', StatusDokumentuRealizacjiReceptyEnumMT::getValidValues())), __LINE__);
        }
        $this->statusDokumentuRealizacjiRecepty = $statusDokumentuRealizacjiRecepty;
        return $this;
    }
}
