<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KryteriaWyszukiwaniaDokumentowAnulowaniaMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Kryteria wyszukiwania dokumentów anulowania recept.
 * @subpackage Structs
 */
class KryteriaWyszukiwaniaDokumentowAnulowaniaMT extends AbstractStructBase
{
    /**
     * The dataWystawieniaOd
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu anulowania (data OD).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaOd;
    /**
     * The dataWystawieniaDo
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu anulowania (data DO).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaDo;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty, którego dotyczy szukany dokument anulowania,
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * Constructor method for KryteriaWyszukiwaniaDokumentowAnulowaniaMT
     * @uses KryteriaWyszukiwaniaDokumentowAnulowaniaMT::setDataWystawieniaOd()
     * @uses KryteriaWyszukiwaniaDokumentowAnulowaniaMT::setDataWystawieniaDo()
     * @uses KryteriaWyszukiwaniaDokumentowAnulowaniaMT::setNumerRecepty()
     * @param string $dataWystawieniaOd
     * @param string $dataWystawieniaDo
     * @param NumerReceptyOIDMT $numerRecepty
     */
    public function __construct($dataWystawieniaOd = null, $dataWystawieniaDo = null, NumerReceptyOIDMT $numerRecepty = null)
    {
        $this
            ->setDataWystawieniaOd($dataWystawieniaOd)
            ->setDataWystawieniaDo($dataWystawieniaDo)
            ->setNumerRecepty($numerRecepty);
    }
    /**
     * Get dataWystawieniaOd value
     * @return string|null
     */
    public function getDataWystawieniaOd()
    {
        return $this->dataWystawieniaOd;
    }
    /**
     * Set dataWystawieniaOd value
     * @param string $dataWystawieniaOd
     * @return KryteriaWyszukiwaniaDokumentowAnulowaniaMT
     */
    public function setDataWystawieniaOd($dataWystawieniaOd = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaOd) && !is_string($dataWystawieniaOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaOd, true), gettype($dataWystawieniaOd)), __LINE__);
        }
        $this->dataWystawieniaOd = $dataWystawieniaOd;
        return $this;
    }
    /**
     * Get dataWystawieniaDo value
     * @return string|null
     */
    public function getDataWystawieniaDo()
    {
        return $this->dataWystawieniaDo;
    }
    /**
     * Set dataWystawieniaDo value
     * @param string $dataWystawieniaDo
     * @return KryteriaWyszukiwaniaDokumentowAnulowaniaMT
     */
    public function setDataWystawieniaDo($dataWystawieniaDo = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaDo) && !is_string($dataWystawieniaDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaDo, true), gettype($dataWystawieniaDo)), __LINE__);
        }
        $this->dataWystawieniaDo = $dataWystawieniaDo;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT|null
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return KryteriaWyszukiwaniaDokumentowAnulowaniaMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
}
