<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DaneRealizacjiDoKonsultacjiMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Dane pojedynczej recepty w ramach udostępnianego pakietu recept usługobiorcy do konsultacji.
 * @subpackage Structs
 */
class DaneRealizacjiDoKonsultacjiMT extends AbstractStructBase
{
    /**
     * The dataRealizacjiRecepty
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu realizacji
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dataRealizacjiRecepty;
    /**
     * The iloscWydanegoLeku
     * Meta information extracted from the WSDL
     * - documentation: Ilośc wydanego leku w ramach realizacji
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $iloscWydanegoLeku;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * The nazwaLekuRealizacja
     * Meta information extracted from the WSDL
     * - documentation: Nazwa leku wydanego.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nazwaLekuRealizacja;
    /**
     * Constructor method for DaneRealizacjiDoKonsultacjiMT
     * @uses DaneRealizacjiDoKonsultacjiMT::setDataRealizacjiRecepty()
     * @uses DaneRealizacjiDoKonsultacjiMT::setIloscWydanegoLeku()
     * @uses DaneRealizacjiDoKonsultacjiMT::setNumerRecepty()
     * @uses DaneRealizacjiDoKonsultacjiMT::setNazwaLekuRealizacja()
     * @param string $dataRealizacjiRecepty
     * @param float $iloscWydanegoLeku
     * @param NumerReceptyOIDMT $numerRecepty
     * @param string $nazwaLekuRealizacja
     */
    public function __construct($dataRealizacjiRecepty = null, $iloscWydanegoLeku = null, NumerReceptyOIDMT $numerRecepty = null, $nazwaLekuRealizacja = null)
    {
        $this
            ->setDataRealizacjiRecepty($dataRealizacjiRecepty)
            ->setIloscWydanegoLeku($iloscWydanegoLeku)
            ->setNumerRecepty($numerRecepty)
            ->setNazwaLekuRealizacja($nazwaLekuRealizacja);
    }
    /**
     * Get dataRealizacjiRecepty value
     * @return string
     */
    public function getDataRealizacjiRecepty()
    {
        return $this->dataRealizacjiRecepty;
    }
    /**
     * Set dataRealizacjiRecepty value
     * @param string $dataRealizacjiRecepty
     * @return DaneRealizacjiDoKonsultacjiMT
     */
    public function setDataRealizacjiRecepty($dataRealizacjiRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($dataRealizacjiRecepty) && !is_string($dataRealizacjiRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRealizacjiRecepty, true), gettype($dataRealizacjiRecepty)), __LINE__);
        }
        $this->dataRealizacjiRecepty = $dataRealizacjiRecepty;
        return $this;
    }
    /**
     * Get iloscWydanegoLeku value
     * @return float
     */
    public function getIloscWydanegoLeku()
    {
        return $this->iloscWydanegoLeku;
    }
    /**
     * Set iloscWydanegoLeku value
     * @param float $iloscWydanegoLeku
     * @return DaneRealizacjiDoKonsultacjiMT
     */
    public function setIloscWydanegoLeku($iloscWydanegoLeku = null)
    {
        // validation for constraint: float
        if (!is_null($iloscWydanegoLeku) && !(is_float($iloscWydanegoLeku) || is_numeric($iloscWydanegoLeku))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iloscWydanegoLeku, true), gettype($iloscWydanegoLeku)), __LINE__);
        }
        $this->iloscWydanegoLeku = $iloscWydanegoLeku;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return DaneRealizacjiDoKonsultacjiMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
    /**
     * Get nazwaLekuRealizacja value
     * @return string|null
     */
    public function getNazwaLekuRealizacja()
    {
        return $this->nazwaLekuRealizacja;
    }
    /**
     * Set nazwaLekuRealizacja value
     * @param string $nazwaLekuRealizacja
     * @return DaneRealizacjiDoKonsultacjiMT
     */
    public function setNazwaLekuRealizacja($nazwaLekuRealizacja = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaLekuRealizacja) && !is_string($nazwaLekuRealizacja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaLekuRealizacja, true), gettype($nazwaLekuRealizacja)), __LINE__);
        }
        $this->nazwaLekuRealizacja = $nazwaLekuRealizacja;
        return $this;
    }
}
