<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BladMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Błędy techniczne (nie biznesowe).
 * @subpackage Structs
 */
class BladMT extends AbstractStructBase
{
    /**
     * The kodBleduMajor
     * Meta information extracted from the WSDL
     * - documentation: Kod wyniku - część główna
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kodBleduMajor;
    /**
     * The kodBleduMinor
     * Meta information extracted from the WSDL
     * - documentation: Kod wyniku - część dodatkowa
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kodBleduMinor;
    /**
     * The opis
     * Meta information extracted from the WSDL
     * - documentation: Tekstowy opis błędu.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $opis;
    /**
     * Constructor method for BladMT
     * @uses BladMT::setKodBleduMajor()
     * @uses BladMT::setKodBleduMinor()
     * @uses BladMT::setOpis()
     * @param string $kodBleduMajor
     * @param string $kodBleduMinor
     * @param string $opis
     */
    public function __construct($kodBleduMajor = null, $kodBleduMinor = null, $opis = null)
    {
        $this
            ->setKodBleduMajor($kodBleduMajor)
            ->setKodBleduMinor($kodBleduMinor)
            ->setOpis($opis);
    }
    /**
     * Get kodBleduMajor value
     * @return string
     */
    public function getKodBleduMajor()
    {
        return $this->kodBleduMajor;
    }
    /**
     * Set kodBleduMajor value
     * @uses KodBleduMajorMT::valueIsValid()
     * @uses KodBleduMajorMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kodBleduMajor
     * @return BladMT
     */
    public function setKodBleduMajor($kodBleduMajor = null)
    {
        // validation for constraint: enumeration
        if (!KodBleduMajorMT::valueIsValid($kodBleduMajor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class KodBleduMajorMT', is_array($kodBleduMajor) ? implode(', ', $kodBleduMajor) : var_export($kodBleduMajor, true), implode(', ', KodBleduMajorMT::getValidValues())), __LINE__);
        }
        $this->kodBleduMajor = $kodBleduMajor;
        return $this;
    }
    /**
     * Get kodBleduMinor value
     * @return string|null
     */
    public function getKodBleduMinor()
    {
        return $this->kodBleduMinor;
    }
    /**
     * Set kodBleduMinor value
     * @uses KodBleduMinorMT::valueIsValid()
     * @uses KodBleduMinorMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kodBleduMinor
     * @return BladMT
     */
    public function setKodBleduMinor($kodBleduMinor = null)
    {
        // validation for constraint: enumeration
        if (!KodBleduMinorMT::valueIsValid($kodBleduMinor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class KodBleduMinorMT', is_array($kodBleduMinor) ? implode(', ', $kodBleduMinor) : var_export($kodBleduMinor, true), implode(', ', KodBleduMinorMT::getValidValues())), __LINE__);
        }
        $this->kodBleduMinor = $kodBleduMinor;
        return $this;
    }
    /**
     * Get opis value
     * @return string|null
     */
    public function getOpis()
    {
        return $this->opis;
    }
    /**
     * Set opis value
     * @param string $opis
     * @return BladMT
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opis, true), gettype($opis)), __LINE__);
        }
        $this->opis = $opis;
        return $this;
    }
}
