<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametryStronicowaniaMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Parametry stonicowania wyników wyszukiwania.
 * @subpackage Structs
 */
class ParametryStronicowaniaMT extends AbstractStructBase
{
    /**
     * The rozmiarStrony
     * Meta information extracted from the WSDL
     * - documentation: Określa liczbę rekordów dla pełnej porcji danych. Maksymalna wartość będzie ograniczona parametrem systemowym.
     * - base: xs:unsignedInt
     * - maxOccurs: 1
     * - minInclusive: 1
     * - minOccurs: 1
     * @var int
     */
    public $rozmiarStrony;
    /**
     * The numerStrony
     * Meta information extracted from the WSDL
     * - documentation: Określa numer pobieranej strony. Numeracja stron od 0.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numerStrony;
    /**
     * The kierunekSortowania
     * Meta information extracted from the WSDL
     * - documentation: Określa kierunek sortowania dla domyślnej kolumny po której sortowany jest wynik.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kierunekSortowania;
    /**
     * The czyPodacLiczbeRek
     * Meta information extracted from the WSDL
     * - documentation: Określa czy system ma dodatkowo zliczać i przekazywać informację o liczbie rekordów spełniających kryteria wyszukiwania.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $czyPodacLiczbeRek;
    /**
     * Constructor method for ParametryStronicowaniaMT
     * @uses ParametryStronicowaniaMT::setRozmiarStrony()
     * @uses ParametryStronicowaniaMT::setNumerStrony()
     * @uses ParametryStronicowaniaMT::setKierunekSortowania()
     * @uses ParametryStronicowaniaMT::setCzyPodacLiczbeRek()
     * @param int $rozmiarStrony
     * @param int $numerStrony
     * @param string $kierunekSortowania
     * @param bool $czyPodacLiczbeRek
     */
    public function __construct($rozmiarStrony = null, $numerStrony = null, $kierunekSortowania = null, $czyPodacLiczbeRek = null)
    {
        $this
            ->setRozmiarStrony($rozmiarStrony)
            ->setNumerStrony($numerStrony)
            ->setKierunekSortowania($kierunekSortowania)
            ->setCzyPodacLiczbeRek($czyPodacLiczbeRek);
    }
    /**
     * Get rozmiarStrony value
     * @return int
     */
    public function getRozmiarStrony()
    {
        return $this->rozmiarStrony;
    }
    /**
     * Set rozmiarStrony value
     * @param int $rozmiarStrony
     * @return ParametryStronicowaniaMT
     */
    public function setRozmiarStrony($rozmiarStrony = null)
    {
        // validation for constraint: int
        if (!is_null($rozmiarStrony) && !(is_int($rozmiarStrony) || ctype_digit($rozmiarStrony))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rozmiarStrony, true), gettype($rozmiarStrony)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($rozmiarStrony) && $rozmiarStrony < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($rozmiarStrony, true)), __LINE__);
        }
        $this->rozmiarStrony = $rozmiarStrony;
        return $this;
    }
    /**
     * Get numerStrony value
     * @return int
     */
    public function getNumerStrony()
    {
        return $this->numerStrony;
    }
    /**
     * Set numerStrony value
     * @param int $numerStrony
     * @return ParametryStronicowaniaMT
     */
    public function setNumerStrony($numerStrony = null)
    {
        // validation for constraint: int
        if (!is_null($numerStrony) && !(is_int($numerStrony) || ctype_digit($numerStrony))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numerStrony, true), gettype($numerStrony)), __LINE__);
        }
        $this->numerStrony = $numerStrony;
        return $this;
    }
    /**
     * Get kierunekSortowania value
     * @return string
     */
    public function getKierunekSortowania()
    {
        return $this->kierunekSortowania;
    }
    /**
     * Set kierunekSortowania value
     * @uses KierunekSortowaniaEnumMT::valueIsValid()
     * @uses KierunekSortowaniaEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kierunekSortowania
     * @return ParametryStronicowaniaMT
     */
    public function setKierunekSortowania($kierunekSortowania = null)
    {
        // validation for constraint: enumeration
        if (!KierunekSortowaniaEnumMT::valueIsValid($kierunekSortowania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class KierunekSortowaniaEnumMT', is_array($kierunekSortowania) ? implode(', ', $kierunekSortowania) : var_export($kierunekSortowania, true), implode(', ', KierunekSortowaniaEnumMT::getValidValues())), __LINE__);
        }
        $this->kierunekSortowania = $kierunekSortowania;
        return $this;
    }
    /**
     * Get czyPodacLiczbeRek value
     * @return bool
     */
    public function getCzyPodacLiczbeRek()
    {
        return $this->czyPodacLiczbeRek;
    }
    /**
     * Set czyPodacLiczbeRek value
     * @param bool $czyPodacLiczbeRek
     * @return ParametryStronicowaniaMT
     */
    public function setCzyPodacLiczbeRek($czyPodacLiczbeRek = null)
    {
        // validation for constraint: boolean
        if (!is_null($czyPodacLiczbeRek) && !is_bool($czyPodacLiczbeRek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($czyPodacLiczbeRek, true), gettype($czyPodacLiczbeRek)), __LINE__);
        }
        $this->czyPodacLiczbeRek = $czyPodacLiczbeRek;
        return $this;
    }
}
