<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Kryteria wyszukiwania realizacji recept usługobiorcy do konsultacji.
 * @subpackage Structs
 */
class KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT extends AbstractStructBase
{
    /**
     * The idUslugobiorcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator usługobiorcy, dla którego została wystawiona realizacja recepty.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var IdentyfikatorUslugobiorcyOIDMT
     */
    public $idUslugobiorcy;
    /**
     * The dataRealizacjaReceptyDo
     * Meta information extracted from the WSDL
     * - documentation: Górne ograniczenie daty wystawienia realizacji recepty - data do kiedy wystawione mają być poszukiwane realizacje recepty. Wartość w tym polu musi być nie mniejsza niż data podana w dolnym ograniczeniu daty wystawienia
     * realizacji recepty (o ile podano dolne ograniczenie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataRealizacjaReceptyDo;
    /**
     * The dataRealizacjiReceptyOd
     * Meta information extracted from the WSDL
     * - documentation: Dolne ograniczenie daty wystawienia realizacji recepty - data od kiedy wystawione mają być poszukiwane realizacje recepty. Wartość w tym polu musi być nie większa niż data podana w górnym ograniczeniu daty wystawienia
     * realizacji recepty (o ile podano górne ograniczenie).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataRealizacjiReceptyOd;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty nadany przez usługodawcę wystawiającego receptę.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * Constructor method for KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT
     * @uses KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT::setIdUslugobiorcy()
     * @uses KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT::setDataRealizacjaReceptyDo()
     * @uses KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT::setDataRealizacjiReceptyOd()
     * @uses KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT::setNumerRecepty()
     * @param IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy
     * @param string $dataRealizacjaReceptyDo
     * @param string $dataRealizacjiReceptyOd
     * @param NumerReceptyOIDMT $numerRecepty
     */
    public function __construct(IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy = null, $dataRealizacjaReceptyDo = null, $dataRealizacjiReceptyOd = null, NumerReceptyOIDMT $numerRecepty = null)
    {
        $this
            ->setIdUslugobiorcy($idUslugobiorcy)
            ->setDataRealizacjaReceptyDo($dataRealizacjaReceptyDo)
            ->setDataRealizacjiReceptyOd($dataRealizacjiReceptyOd)
            ->setNumerRecepty($numerRecepty);
    }
    /**
     * Get idUslugobiorcy value
     * @return IdentyfikatorUslugobiorcyOIDMT
     */
    public function getIdUslugobiorcy()
    {
        return $this->idUslugobiorcy;
    }
    /**
     * Set idUslugobiorcy value
     * @param IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy
     * @return KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT
     */
    public function setIdUslugobiorcy(IdentyfikatorUslugobiorcyOIDMT $idUslugobiorcy = null)
    {
        $this->idUslugobiorcy = $idUslugobiorcy;
        return $this;
    }
    /**
     * Get dataRealizacjaReceptyDo value
     * @return string|null
     */
    public function getDataRealizacjaReceptyDo()
    {
        return $this->dataRealizacjaReceptyDo;
    }
    /**
     * Set dataRealizacjaReceptyDo value
     * @param string $dataRealizacjaReceptyDo
     * @return KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT
     */
    public function setDataRealizacjaReceptyDo($dataRealizacjaReceptyDo = null)
    {
        // validation for constraint: string
        if (!is_null($dataRealizacjaReceptyDo) && !is_string($dataRealizacjaReceptyDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRealizacjaReceptyDo, true), gettype($dataRealizacjaReceptyDo)), __LINE__);
        }
        $this->dataRealizacjaReceptyDo = $dataRealizacjaReceptyDo;
        return $this;
    }
    /**
     * Get dataRealizacjiReceptyOd value
     * @return string|null
     */
    public function getDataRealizacjiReceptyOd()
    {
        return $this->dataRealizacjiReceptyOd;
    }
    /**
     * Set dataRealizacjiReceptyOd value
     * @param string $dataRealizacjiReceptyOd
     * @return KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT
     */
    public function setDataRealizacjiReceptyOd($dataRealizacjiReceptyOd = null)
    {
        // validation for constraint: string
        if (!is_null($dataRealizacjiReceptyOd) && !is_string($dataRealizacjiReceptyOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRealizacjiReceptyOd, true), gettype($dataRealizacjiReceptyOd)), __LINE__);
        }
        $this->dataRealizacjiReceptyOd = $dataRealizacjiReceptyOd;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT|null
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return KryteriaWyszukiwaniaRealizacjiReceptDoKonsultacjiMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
}
