<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KontekstMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Kontekst wywołania usługi. Realizowany w postaci ws-security custom token.
 * @subpackage Structs
 */
class KontekstMT extends AbstractStructBase
{
    /**
     * The atrybut
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AtrybutMT[]
     */
    public $atrybut;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - ref: wsu:Id
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for KontekstMT
     * @uses KontekstMT::setAtrybut()
     * @uses KontekstMT::setId()
     * @param AtrybutMT[] $atrybut
     * @param string $id
     */
    public function __construct(array $atrybut = array(), $id = null)
    {
        $this
            ->setAtrybut($atrybut)
            ->setId($id);
    }
    /**
     * Get atrybut value
     * @return AtrybutMT[]|null
     */
    public function getAtrybut()
    {
        return $this->atrybut;
    }
    /**
     * This method is responsible for validating the values passed to the setAtrybut method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAtrybut method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAtrybutForArrayConstraintsFromSetAtrybut(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontekstMTAtrybutItem) {
            // validation for constraint: itemType
            if (!$kontekstMTAtrybutItem instanceof AtrybutMT) {
                $invalidValues[] = is_object($kontekstMTAtrybutItem) ? get_class($kontekstMTAtrybutItem) : sprintf('%s(%s)', gettype($kontekstMTAtrybutItem), var_export($kontekstMTAtrybutItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The atrybut property can only contain items of type AtrybutMT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set atrybut value
     * @throws \InvalidArgumentException
     * @param AtrybutMT[] $atrybut
     * @return KontekstMT
     */
    public function setAtrybut(array $atrybut = array())
    {
        // validation for constraint: array
        if ('' !== ($atrybutArrayErrorMessage = self::validateAtrybutForArrayConstraintsFromSetAtrybut($atrybut))) {
            throw new \InvalidArgumentException($atrybutArrayErrorMessage, __LINE__);
        }
        $this->atrybut = $atrybut;
        return $this;
    }
    /**
     * Add item to atrybut value
     * @throws \InvalidArgumentException
     * @param AtrybutMT $item
     * @return KontekstMT
     */
    public function addToAtrybut(AtrybutMT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof AtrybutMT) {
            throw new \InvalidArgumentException(sprintf('The atrybut property can only contain items of type AtrybutMT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->atrybut[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return KontekstMT
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
