<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KluczINumerReceptyMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Klucz i numer recepty.
 * @subpackage Structs
 */
class KluczINumerReceptyMT extends AbstractStructBase
{
    /**
     * The kluczRecepty
     * Meta information extracted from the WSDL
     * - documentation: Klucz recepty nadany przez P1.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kluczRecepty;
    /**
     * The numerRecepty
     * Meta information extracted from the WSDL
     * - documentation: Numer recepty nadany przez usługodawcę.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NumerReceptyOIDMT
     */
    public $numerRecepty;
    /**
     * Constructor method for KluczINumerReceptyMT
     * @uses KluczINumerReceptyMT::setKluczRecepty()
     * @uses KluczINumerReceptyMT::setNumerRecepty()
     * @param string $kluczRecepty
     * @param NumerReceptyOIDMT $numerRecepty
     */
    public function __construct($kluczRecepty = null, NumerReceptyOIDMT $numerRecepty = null)
    {
        $this
            ->setKluczRecepty($kluczRecepty)
            ->setNumerRecepty($numerRecepty);
    }
    /**
     * Get kluczRecepty value
     * @return string
     */
    public function getKluczRecepty()
    {
        return $this->kluczRecepty;
    }
    /**
     * Set kluczRecepty value
     * @param string $kluczRecepty
     * @return KluczINumerReceptyMT
     */
    public function setKluczRecepty($kluczRecepty = null)
    {
        // validation for constraint: string
        if (!is_null($kluczRecepty) && !is_string($kluczRecepty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kluczRecepty, true), gettype($kluczRecepty)), __LINE__);
        }
        $this->kluczRecepty = $kluczRecepty;
        return $this;
    }
    /**
     * Get numerRecepty value
     * @return NumerReceptyOIDMT
     */
    public function getNumerRecepty()
    {
        return $this->numerRecepty;
    }
    /**
     * Set numerRecepty value
     * @param NumerReceptyOIDMT $numerRecepty
     * @return KluczINumerReceptyMT
     */
    public function setNumerRecepty(NumerReceptyOIDMT $numerRecepty = null)
    {
        $this->numerRecepty = $numerRecepty;
        return $this;
    }
}
