<?php

namespace xt_soapapi\xt_soapapi-php\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClient ArrayType
 * @subpackage Arrays
 */
class ArrayOfClient extends AbstractStructArrayBase
{
    /**
     * The Client
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \xt_soapapi\xt_soapapi-php\StructType\Client[]
     */
    public $Client;
    /**
     * Constructor method for ArrayOfClient
     * @uses ArrayOfClient::setClient()
     * @param \xt_soapapi\xt_soapapi-php\StructType\Client[] $client
     */
    public function __construct(array $client = array())
    {
        $this
            ->setClient($client);
    }
    /**
     * Get Client value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \xt_soapapi\xt_soapapi-php\StructType\Client[]|null
     */
    public function getClient()
    {
        return isset($this->Client) ? $this->Client : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClient method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClient method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientForArrayConstraintsFromSetClient(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfClientClientItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientClientItem instanceof \xt_soapapi\xt_soapapi-php\StructType\Client) {
                $invalidValues[] = is_object($arrayOfClientClientItem) ? get_class($arrayOfClientClientItem) : sprintf('%s(%s)', gettype($arrayOfClientClientItem), var_export($arrayOfClientClientItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Client property can only contain items of type \xt_soapapi\xt_soapapi-php\StructType\Client, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Client value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \xt_soapapi\xt_soapapi-php\StructType\Client[] $client
     * @return \xt_soapapi\xt_soapapi-php\ArrayType\ArrayOfClient
     */
    public function setClient(array $client = array())
    {
        // validation for constraint: array
        if ('' !== ($clientArrayErrorMessage = self::validateClientForArrayConstraintsFromSetClient($client))) {
            throw new \InvalidArgumentException($clientArrayErrorMessage, __LINE__);
        }
        if (is_null($client) || (is_array($client) && empty($client))) {
            unset($this->Client);
        } else {
            $this->Client = $client;
        }
        return $this;
    }
    /**
     * Add item to Client value
     * @throws \InvalidArgumentException
     * @param \xt_soapapi\xt_soapapi-php\StructType\Client $item
     * @return \xt_soapapi\xt_soapapi-php\ArrayType\ArrayOfClient
     */
    public function addToClient(\xt_soapapi\xt_soapapi-php\StructType\Client $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \xt_soapapi\xt_soapapi-php\StructType\Client) {
            throw new \InvalidArgumentException(sprintf('The Client property can only contain items of type \xt_soapapi\xt_soapapi-php\StructType\Client, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Client[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \xt_soapapi\xt_soapapi-php\StructType\Client|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \xt_soapapi\xt_soapapi-php\StructType\Client|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \xt_soapapi\xt_soapapi-php\StructType\Client|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \xt_soapapi\xt_soapapi-php\StructType\Client|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \xt_soapapi\xt_soapapi-php\StructType\Client|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Client
     */
    public function getAttributeName()
    {
        return 'Client';
    }
}
