<?php

namespace xt_soapapi\xt_soapapi-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreerClient StructType
 * @subpackage Structs
 */
class CreerClient extends AbstractStructBase
{
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The client
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \xt_soapapi\xt_soapapi-php\StructType\Client
     */
    public $client;
    /**
     * Constructor method for CreerClient
     * @uses CreerClient::setUser()
     * @uses CreerClient::setPassword()
     * @uses CreerClient::setClient()
     * @param string $user
     * @param string $password
     * @param \xt_soapapi\xt_soapapi-php\StructType\Client $client
     */
    public function __construct($user = null, $password = null, \xt_soapapi\xt_soapapi-php\StructType\Client $client = null)
    {
        $this
            ->setUser($user)
            ->setPassword($password)
            ->setClient($client);
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \xt_soapapi\xt_soapapi-php\StructType\CreerClient
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \xt_soapapi\xt_soapapi-php\StructType\CreerClient
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get client value
     * @return \xt_soapapi\xt_soapapi-php\StructType\Client|null
     */
    public function getClient()
    {
        return $this->client;
    }
    /**
     * Set client value
     * @param \xt_soapapi\xt_soapapi-php\StructType\Client $client
     * @return \xt_soapapi\xt_soapapi-php\StructType\CreerClient
     */
    public function setClient(\xt_soapapi\xt_soapapi-php\StructType\Client $client = null)
    {
        $this->client = $client;
        return $this;
    }
}
