<?php

namespace xt_soapapi\xt_soapapi-php\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Charger ServiceType
 * @subpackage Services
 */
class Charger extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChargerClients
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \xt_soapapi\xt_soapapi-php\StructType\ChargerClients $parameters
     * @return \xt_soapapi\xt_soapapi-php\StructType\ChargerClientsResponse|bool
     */
    public function ChargerClients(\xt_soapapi\xt_soapapi-php\StructType\ChargerClients $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChargerClients($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargerModesReglement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \xt_soapapi\xt_soapapi-php\StructType\ChargerModesReglement $parameters
     * @return \xt_soapapi\xt_soapapi-php\StructType\ChargerModesReglementResponse|bool
     */
    public function ChargerModesReglement(\xt_soapapi\xt_soapapi-php\StructType\ChargerModesReglement $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChargerModesReglement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChargerProduit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \xt_soapapi\xt_soapapi-php\StructType\ChargerProduit $parameters
     * @return \xt_soapapi\xt_soapapi-php\StructType\ChargerProduitResponse|bool
     */
    public function ChargerProduit(\xt_soapapi\xt_soapapi-php\StructType\ChargerProduit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChargerProduit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \xt_soapapi\xt_soapapi-php\StructType\ChargerClientsResponse|\xt_soapapi\xt_soapapi-php\StructType\ChargerModesReglementResponse|\xt_soapapi\xt_soapapi-php\StructType\ChargerProduitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
