<?php

namespace xt_soapapi\xt_soapapi-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockMagasin StructType
 * @subpackage Structs
 */
class StockMagasin extends AbstractStructBase
{
    /**
     * The QteStock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QteStock;
    /**
     * The Magasin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Magasin;
    /**
     * Constructor method for StockMagasin
     * @uses StockMagasin::setQteStock()
     * @uses StockMagasin::setMagasin()
     * @param float $qteStock
     * @param string $magasin
     */
    public function __construct($qteStock = null, $magasin = null)
    {
        $this
            ->setQteStock($qteStock)
            ->setMagasin($magasin);
    }
    /**
     * Get QteStock value
     * @return float
     */
    public function getQteStock()
    {
        return $this->QteStock;
    }
    /**
     * Set QteStock value
     * @param float $qteStock
     * @return \xt_soapapi\xt_soapapi-php\StructType\StockMagasin
     */
    public function setQteStock($qteStock = null)
    {
        // validation for constraint: float
        if (!is_null($qteStock) && !(is_float($qteStock) || is_numeric($qteStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qteStock, true), gettype($qteStock)), __LINE__);
        }
        $this->QteStock = $qteStock;
        return $this;
    }
    /**
     * Get Magasin value
     * @return string|null
     */
    public function getMagasin()
    {
        return $this->Magasin;
    }
    /**
     * Set Magasin value
     * @param string $magasin
     * @return \xt_soapapi\xt_soapapi-php\StructType\StockMagasin
     */
    public function setMagasin($magasin = null)
    {
        // validation for constraint: string
        if (!is_null($magasin) && !is_string($magasin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magasin, true), gettype($magasin)), __LINE__);
        }
        $this->Magasin = $magasin;
        return $this;
    }
}
