<?php

namespace xt_soapapi\xt_soapapi-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LigneReglement StructType
 * @subpackage Structs
 */
class LigneReglement extends AbstractStructBase
{
    /**
     * The MtRegle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MtRegle;
    /**
     * The CodeSupportReglement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeSupportReglement;
    /**
     * Constructor method for LigneReglement
     * @uses LigneReglement::setMtRegle()
     * @uses LigneReglement::setCodeSupportReglement()
     * @param float $mtRegle
     * @param string $codeSupportReglement
     */
    public function __construct($mtRegle = null, $codeSupportReglement = null)
    {
        $this
            ->setMtRegle($mtRegle)
            ->setCodeSupportReglement($codeSupportReglement);
    }
    /**
     * Get MtRegle value
     * @return float
     */
    public function getMtRegle()
    {
        return $this->MtRegle;
    }
    /**
     * Set MtRegle value
     * @param float $mtRegle
     * @return \xt_soapapi\xt_soapapi-php\StructType\LigneReglement
     */
    public function setMtRegle($mtRegle = null)
    {
        // validation for constraint: float
        if (!is_null($mtRegle) && !(is_float($mtRegle) || is_numeric($mtRegle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mtRegle, true), gettype($mtRegle)), __LINE__);
        }
        $this->MtRegle = $mtRegle;
        return $this;
    }
    /**
     * Get CodeSupportReglement value
     * @return string|null
     */
    public function getCodeSupportReglement()
    {
        return $this->CodeSupportReglement;
    }
    /**
     * Set CodeSupportReglement value
     * @param string $codeSupportReglement
     * @return \xt_soapapi\xt_soapapi-php\StructType\LigneReglement
     */
    public function setCodeSupportReglement($codeSupportReglement = null)
    {
        // validation for constraint: string
        if (!is_null($codeSupportReglement) && !is_string($codeSupportReglement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeSupportReglement, true), gettype($codeSupportReglement)), __LINE__);
        }
        $this->CodeSupportReglement = $codeSupportReglement;
        return $this;
    }
}
