<?php

namespace xt_soapapi\xt_soapapi-php\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcartStock StructType
 * @subpackage Structs
 */
class EcartStock extends AbstractStructBase
{
    /**
     * The QteEcart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QteEcart;
    /**
     * The PxVentePub
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PxVentePub;
    /**
     * The CAPotentiel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CAPotentiel;
    /**
     * The QteStock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QteStock;
    /**
     * The Magasin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Magasin;
    /**
     * The CodeFab
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeFab;
    /**
     * The LibFab
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibFab;
    /**
     * The RefFab
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefFab;
    /**
     * The Taille
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Taille;
    /**
     * The Lib
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lib;
    /**
     * The CodeMarque
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeMarque;
    /**
     * The LibMarque
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibMarque;
    /**
     * The CodeProduit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeProduit;
    /**
     * Constructor method for EcartStock
     * @uses EcartStock::setQteEcart()
     * @uses EcartStock::setPxVentePub()
     * @uses EcartStock::setCAPotentiel()
     * @uses EcartStock::setQteStock()
     * @uses EcartStock::setMagasin()
     * @uses EcartStock::setCodeFab()
     * @uses EcartStock::setLibFab()
     * @uses EcartStock::setRefFab()
     * @uses EcartStock::setTaille()
     * @uses EcartStock::setLib()
     * @uses EcartStock::setCodeMarque()
     * @uses EcartStock::setLibMarque()
     * @uses EcartStock::setCodeProduit()
     * @param float $qteEcart
     * @param float $pxVentePub
     * @param float $cAPotentiel
     * @param float $qteStock
     * @param string $magasin
     * @param string $codeFab
     * @param string $libFab
     * @param string $refFab
     * @param string $taille
     * @param string $lib
     * @param string $codeMarque
     * @param string $libMarque
     * @param string $codeProduit
     */
    public function __construct($qteEcart = null, $pxVentePub = null, $cAPotentiel = null, $qteStock = null, $magasin = null, $codeFab = null, $libFab = null, $refFab = null, $taille = null, $lib = null, $codeMarque = null, $libMarque = null, $codeProduit = null)
    {
        $this
            ->setQteEcart($qteEcart)
            ->setPxVentePub($pxVentePub)
            ->setCAPotentiel($cAPotentiel)
            ->setQteStock($qteStock)
            ->setMagasin($magasin)
            ->setCodeFab($codeFab)
            ->setLibFab($libFab)
            ->setRefFab($refFab)
            ->setTaille($taille)
            ->setLib($lib)
            ->setCodeMarque($codeMarque)
            ->setLibMarque($libMarque)
            ->setCodeProduit($codeProduit);
    }
    /**
     * Get QteEcart value
     * @return float
     */
    public function getQteEcart()
    {
        return $this->QteEcart;
    }
    /**
     * Set QteEcart value
     * @param float $qteEcart
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setQteEcart($qteEcart = null)
    {
        // validation for constraint: float
        if (!is_null($qteEcart) && !(is_float($qteEcart) || is_numeric($qteEcart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qteEcart, true), gettype($qteEcart)), __LINE__);
        }
        $this->QteEcart = $qteEcart;
        return $this;
    }
    /**
     * Get PxVentePub value
     * @return float
     */
    public function getPxVentePub()
    {
        return $this->PxVentePub;
    }
    /**
     * Set PxVentePub value
     * @param float $pxVentePub
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setPxVentePub($pxVentePub = null)
    {
        // validation for constraint: float
        if (!is_null($pxVentePub) && !(is_float($pxVentePub) || is_numeric($pxVentePub))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pxVentePub, true), gettype($pxVentePub)), __LINE__);
        }
        $this->PxVentePub = $pxVentePub;
        return $this;
    }
    /**
     * Get CAPotentiel value
     * @return float
     */
    public function getCAPotentiel()
    {
        return $this->CAPotentiel;
    }
    /**
     * Set CAPotentiel value
     * @param float $cAPotentiel
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setCAPotentiel($cAPotentiel = null)
    {
        // validation for constraint: float
        if (!is_null($cAPotentiel) && !(is_float($cAPotentiel) || is_numeric($cAPotentiel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cAPotentiel, true), gettype($cAPotentiel)), __LINE__);
        }
        $this->CAPotentiel = $cAPotentiel;
        return $this;
    }
    /**
     * Get QteStock value
     * @return float
     */
    public function getQteStock()
    {
        return $this->QteStock;
    }
    /**
     * Set QteStock value
     * @param float $qteStock
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setQteStock($qteStock = null)
    {
        // validation for constraint: float
        if (!is_null($qteStock) && !(is_float($qteStock) || is_numeric($qteStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qteStock, true), gettype($qteStock)), __LINE__);
        }
        $this->QteStock = $qteStock;
        return $this;
    }
    /**
     * Get Magasin value
     * @return string|null
     */
    public function getMagasin()
    {
        return $this->Magasin;
    }
    /**
     * Set Magasin value
     * @param string $magasin
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setMagasin($magasin = null)
    {
        // validation for constraint: string
        if (!is_null($magasin) && !is_string($magasin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magasin, true), gettype($magasin)), __LINE__);
        }
        $this->Magasin = $magasin;
        return $this;
    }
    /**
     * Get CodeFab value
     * @return string|null
     */
    public function getCodeFab()
    {
        return $this->CodeFab;
    }
    /**
     * Set CodeFab value
     * @param string $codeFab
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setCodeFab($codeFab = null)
    {
        // validation for constraint: string
        if (!is_null($codeFab) && !is_string($codeFab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeFab, true), gettype($codeFab)), __LINE__);
        }
        $this->CodeFab = $codeFab;
        return $this;
    }
    /**
     * Get LibFab value
     * @return string|null
     */
    public function getLibFab()
    {
        return $this->LibFab;
    }
    /**
     * Set LibFab value
     * @param string $libFab
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setLibFab($libFab = null)
    {
        // validation for constraint: string
        if (!is_null($libFab) && !is_string($libFab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($libFab, true), gettype($libFab)), __LINE__);
        }
        $this->LibFab = $libFab;
        return $this;
    }
    /**
     * Get RefFab value
     * @return string|null
     */
    public function getRefFab()
    {
        return $this->RefFab;
    }
    /**
     * Set RefFab value
     * @param string $refFab
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setRefFab($refFab = null)
    {
        // validation for constraint: string
        if (!is_null($refFab) && !is_string($refFab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refFab, true), gettype($refFab)), __LINE__);
        }
        $this->RefFab = $refFab;
        return $this;
    }
    /**
     * Get Taille value
     * @return string|null
     */
    public function getTaille()
    {
        return $this->Taille;
    }
    /**
     * Set Taille value
     * @param string $taille
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setTaille($taille = null)
    {
        // validation for constraint: string
        if (!is_null($taille) && !is_string($taille)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taille, true), gettype($taille)), __LINE__);
        }
        $this->Taille = $taille;
        return $this;
    }
    /**
     * Get Lib value
     * @return string|null
     */
    public function getLib()
    {
        return $this->Lib;
    }
    /**
     * Set Lib value
     * @param string $lib
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setLib($lib = null)
    {
        // validation for constraint: string
        if (!is_null($lib) && !is_string($lib)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lib, true), gettype($lib)), __LINE__);
        }
        $this->Lib = $lib;
        return $this;
    }
    /**
     * Get CodeMarque value
     * @return string|null
     */
    public function getCodeMarque()
    {
        return $this->CodeMarque;
    }
    /**
     * Set CodeMarque value
     * @param string $codeMarque
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setCodeMarque($codeMarque = null)
    {
        // validation for constraint: string
        if (!is_null($codeMarque) && !is_string($codeMarque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeMarque, true), gettype($codeMarque)), __LINE__);
        }
        $this->CodeMarque = $codeMarque;
        return $this;
    }
    /**
     * Get LibMarque value
     * @return string|null
     */
    public function getLibMarque()
    {
        return $this->LibMarque;
    }
    /**
     * Set LibMarque value
     * @param string $libMarque
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setLibMarque($libMarque = null)
    {
        // validation for constraint: string
        if (!is_null($libMarque) && !is_string($libMarque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($libMarque, true), gettype($libMarque)), __LINE__);
        }
        $this->LibMarque = $libMarque;
        return $this;
    }
    /**
     * Get CodeProduit value
     * @return string|null
     */
    public function getCodeProduit()
    {
        return $this->CodeProduit;
    }
    /**
     * Set CodeProduit value
     * @param string $codeProduit
     * @return \xt_soapapi\xt_soapapi-php\StructType\EcartStock
     */
    public function setCodeProduit($codeProduit = null)
    {
        // validation for constraint: string
        if (!is_null($codeProduit) && !is_string($codeProduit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeProduit, true), gettype($codeProduit)), __LINE__);
        }
        $this->CodeProduit = $codeProduit;
        return $this;
    }
}
