<?php

namespace EnumType;

/**
 * This class stands for GeslachtType EnumType
 * @subpackage Enumerations
 */
class GeslachtType
{
    /**
     * Constant for value 'Man'
     * @return string 'Man'
     */
    const VALUE_MAN = 'Man';
    /**
     * Constant for value 'Vrouw'
     * @return string 'Vrouw'
     */
    const VALUE_VROUW = 'Vrouw';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MAN
     * @uses self::VALUE_VROUW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MAN,
            self::VALUE_VROUW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
