<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeadGegevens StructType
 * @subpackage Structs
 */
class LeadGegevens extends AbstractStructBase
{
    /**
     * The BezitEigenWoning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $BezitEigenWoning;
    /**
     * The Emailadres
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Emailadres;
    /**
     * The Naam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Naam;
    /**
     * The Plaats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Plaats;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The Straatnaam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Straatnaam;
    /**
     * The TypeLead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TypeLead;
    /**
     * The Voorletters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Voorletters;
    /**
     * The Voornamen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Voornamen;
    /**
     * The Roepnaam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Roepnaam;
    /**
     * The Bedrijfsnaam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bedrijfsnaam;
    /**
     * The BurgelijkeStaat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BurgelijkeStaat;
    /**
     * The Geboortedatum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Geboortedatum;
    /**
     * The Geboorteplaats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Geboorteplaats;
    /**
     * The Geslacht
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Geslacht;
    /**
     * The Huisnummer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Huisnummer;
    /**
     * The Land
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Land;
    /**
     * The Memo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The TelefoonnummerMobiel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TelefoonnummerMobiel;
    /**
     * The TelefoonnummerPrive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TelefoonnummerPrive;
    /**
     * The TelefoonnummerZakelijk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TelefoonnummerZakelijk;
    /**
     * The Toevoeging
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Toevoeging;
    /**
     * The Tussenvoegsel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tussenvoegsel;
    /**
     * The InkomenPerMaand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InkomenPerMaand;
    /**
     * The AantalKinderen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AantalKinderen;
    /**
     * The AantalVolwassenen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AantalVolwassenen;
    /**
     * Constructor method for LeadGegevens
     * @uses LeadGegevens::setBezitEigenWoning()
     * @uses LeadGegevens::setEmailadres()
     * @uses LeadGegevens::setNaam()
     * @uses LeadGegevens::setPlaats()
     * @uses LeadGegevens::setPostcode()
     * @uses LeadGegevens::setStraatnaam()
     * @uses LeadGegevens::setTypeLead()
     * @uses LeadGegevens::setVoorletters()
     * @uses LeadGegevens::setVoornamen()
     * @uses LeadGegevens::setRoepnaam()
     * @uses LeadGegevens::setBedrijfsnaam()
     * @uses LeadGegevens::setBurgelijkeStaat()
     * @uses LeadGegevens::setGeboortedatum()
     * @uses LeadGegevens::setGeboorteplaats()
     * @uses LeadGegevens::setGeslacht()
     * @uses LeadGegevens::setHuisnummer()
     * @uses LeadGegevens::setLand()
     * @uses LeadGegevens::setMemo()
     * @uses LeadGegevens::setTelefoonnummerMobiel()
     * @uses LeadGegevens::setTelefoonnummerPrive()
     * @uses LeadGegevens::setTelefoonnummerZakelijk()
     * @uses LeadGegevens::setToevoeging()
     * @uses LeadGegevens::setTussenvoegsel()
     * @uses LeadGegevens::setInkomenPerMaand()
     * @uses LeadGegevens::setAantalKinderen()
     * @uses LeadGegevens::setAantalVolwassenen()
     * @param bool $bezitEigenWoning
     * @param string $emailadres
     * @param string $naam
     * @param string $plaats
     * @param string $postcode
     * @param string $straatnaam
     * @param string $typeLead
     * @param string $voorletters
     * @param string $voornamen
     * @param string $roepnaam
     * @param string $bedrijfsnaam
     * @param string $burgelijkeStaat
     * @param string $geboortedatum
     * @param string $geboorteplaats
     * @param string $geslacht
     * @param int $huisnummer
     * @param string $land
     * @param string $memo
     * @param string $telefoonnummerMobiel
     * @param string $telefoonnummerPrive
     * @param string $telefoonnummerZakelijk
     * @param string $toevoeging
     * @param string $tussenvoegsel
     * @param int $inkomenPerMaand
     * @param int $aantalKinderen
     * @param int $aantalVolwassenen
     */
    public function __construct($bezitEigenWoning = null, $emailadres = null, $naam = null, $plaats = null, $postcode = null, $straatnaam = null, $typeLead = null, $voorletters = null, $voornamen = null, $roepnaam = null, $bedrijfsnaam = null, $burgelijkeStaat = null, $geboortedatum = null, $geboorteplaats = null, $geslacht = null, $huisnummer = null, $land = null, $memo = null, $telefoonnummerMobiel = null, $telefoonnummerPrive = null, $telefoonnummerZakelijk = null, $toevoeging = null, $tussenvoegsel = null, $inkomenPerMaand = null, $aantalKinderen = null, $aantalVolwassenen = null)
    {
        $this
            ->setBezitEigenWoning($bezitEigenWoning)
            ->setEmailadres($emailadres)
            ->setNaam($naam)
            ->setPlaats($plaats)
            ->setPostcode($postcode)
            ->setStraatnaam($straatnaam)
            ->setTypeLead($typeLead)
            ->setVoorletters($voorletters)
            ->setVoornamen($voornamen)
            ->setRoepnaam($roepnaam)
            ->setBedrijfsnaam($bedrijfsnaam)
            ->setBurgelijkeStaat($burgelijkeStaat)
            ->setGeboortedatum($geboortedatum)
            ->setGeboorteplaats($geboorteplaats)
            ->setGeslacht($geslacht)
            ->setHuisnummer($huisnummer)
            ->setLand($land)
            ->setMemo($memo)
            ->setTelefoonnummerMobiel($telefoonnummerMobiel)
            ->setTelefoonnummerPrive($telefoonnummerPrive)
            ->setTelefoonnummerZakelijk($telefoonnummerZakelijk)
            ->setToevoeging($toevoeging)
            ->setTussenvoegsel($tussenvoegsel)
            ->setInkomenPerMaand($inkomenPerMaand)
            ->setAantalKinderen($aantalKinderen)
            ->setAantalVolwassenen($aantalVolwassenen);
    }
    /**
     * Get BezitEigenWoning value
     * @return bool
     */
    public function getBezitEigenWoning()
    {
        return $this->BezitEigenWoning;
    }
    /**
     * Set BezitEigenWoning value
     * @param bool $bezitEigenWoning
     * @return \StructType\LeadGegevens
     */
    public function setBezitEigenWoning($bezitEigenWoning = null)
    {
        // validation for constraint: boolean
        if (!is_null($bezitEigenWoning) && !is_bool($bezitEigenWoning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bezitEigenWoning)), __LINE__);
        }
        $this->BezitEigenWoning = $bezitEigenWoning;
        return $this;
    }
    /**
     * Get Emailadres value
     * @return string
     */
    public function getEmailadres()
    {
        return $this->Emailadres;
    }
    /**
     * Set Emailadres value
     * @param string $emailadres
     * @return \StructType\LeadGegevens
     */
    public function setEmailadres($emailadres = null)
    {
        // validation for constraint: string
        if (!is_null($emailadres) && !is_string($emailadres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailadres)), __LINE__);
        }
        $this->Emailadres = $emailadres;
        return $this;
    }
    /**
     * Get Naam value
     * @return string
     */
    public function getNaam()
    {
        return $this->Naam;
    }
    /**
     * Set Naam value
     * @param string $naam
     * @return \StructType\LeadGegevens
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naam)), __LINE__);
        }
        $this->Naam = $naam;
        return $this;
    }
    /**
     * Get Plaats value
     * @return string
     */
    public function getPlaats()
    {
        return $this->Plaats;
    }
    /**
     * Set Plaats value
     * @param string $plaats
     * @return \StructType\LeadGegevens
     */
    public function setPlaats($plaats = null)
    {
        // validation for constraint: string
        if (!is_null($plaats) && !is_string($plaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plaats)), __LINE__);
        }
        $this->Plaats = $plaats;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\LeadGegevens
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get Straatnaam value
     * @return string
     */
    public function getStraatnaam()
    {
        return $this->Straatnaam;
    }
    /**
     * Set Straatnaam value
     * @param string $straatnaam
     * @return \StructType\LeadGegevens
     */
    public function setStraatnaam($straatnaam = null)
    {
        // validation for constraint: string
        if (!is_null($straatnaam) && !is_string($straatnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($straatnaam)), __LINE__);
        }
        $this->Straatnaam = $straatnaam;
        return $this;
    }
    /**
     * Get TypeLead value
     * @return string
     */
    public function getTypeLead()
    {
        return $this->TypeLead;
    }
    /**
     * Set TypeLead value
     * @param string $typeLead
     * @return \StructType\LeadGegevens
     */
    public function setTypeLead($typeLead = null)
    {
        // validation for constraint: string
        if (!is_null($typeLead) && !is_string($typeLead)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeLead)), __LINE__);
        }
        $this->TypeLead = $typeLead;
        return $this;
    }
    /**
     * Get Voorletters value
     * @return string
     */
    public function getVoorletters()
    {
        return $this->Voorletters;
    }
    /**
     * Set Voorletters value
     * @param string $voorletters
     * @return \StructType\LeadGegevens
     */
    public function setVoorletters($voorletters = null)
    {
        // validation for constraint: string
        if (!is_null($voorletters) && !is_string($voorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voorletters)), __LINE__);
        }
        $this->Voorletters = $voorletters;
        return $this;
    }
    /**
     * Get Voornamen value
     * @return string
     */
    public function getVoornamen()
    {
        return $this->Voornamen;
    }
    /**
     * Set Voornamen value
     * @param string $voornamen
     * @return \StructType\LeadGegevens
     */
    public function setVoornamen($voornamen = null)
    {
        // validation for constraint: string
        if (!is_null($voornamen) && !is_string($voornamen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voornamen)), __LINE__);
        }
        $this->Voornamen = $voornamen;
        return $this;
    }
    /**
     * Get Roepnaam value
     * @return string
     */
    public function getRoepnaam()
    {
        return $this->Roepnaam;
    }
    /**
     * Set Roepnaam value
     * @param string $roepnaam
     * @return \StructType\LeadGegevens
     */
    public function setRoepnaam($roepnaam = null)
    {
        // validation for constraint: string
        if (!is_null($roepnaam) && !is_string($roepnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roepnaam)), __LINE__);
        }
        $this->Roepnaam = $roepnaam;
        return $this;
    }
    /**
     * Get Bedrijfsnaam value
     * @return string|null
     */
    public function getBedrijfsnaam()
    {
        return $this->Bedrijfsnaam;
    }
    /**
     * Set Bedrijfsnaam value
     * @param string $bedrijfsnaam
     * @return \StructType\LeadGegevens
     */
    public function setBedrijfsnaam($bedrijfsnaam = null)
    {
        // validation for constraint: string
        if (!is_null($bedrijfsnaam) && !is_string($bedrijfsnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bedrijfsnaam)), __LINE__);
        }
        $this->Bedrijfsnaam = $bedrijfsnaam;
        return $this;
    }
    /**
     * Get BurgelijkeStaat value
     * @return string|null
     */
    public function getBurgelijkeStaat()
    {
        return $this->BurgelijkeStaat;
    }
    /**
     * Set BurgelijkeStaat value
     * @param string $burgelijkeStaat
     * @return \StructType\LeadGegevens
     */
    public function setBurgelijkeStaat($burgelijkeStaat = null)
    {
        // validation for constraint: string
        if (!is_null($burgelijkeStaat) && !is_string($burgelijkeStaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($burgelijkeStaat)), __LINE__);
        }
        $this->BurgelijkeStaat = $burgelijkeStaat;
        return $this;
    }
    /**
     * Get Geboortedatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeboortedatum()
    {
        return isset($this->Geboortedatum) ? $this->Geboortedatum : null;
    }
    /**
     * Set Geboortedatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geboortedatum
     * @return \StructType\LeadGegevens
     */
    public function setGeboortedatum($geboortedatum = null)
    {
        // validation for constraint: string
        if (!is_null($geboortedatum) && !is_string($geboortedatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geboortedatum)), __LINE__);
        }
        if (is_null($geboortedatum) || (is_array($geboortedatum) && empty($geboortedatum))) {
            unset($this->Geboortedatum);
        } else {
            $this->Geboortedatum = $geboortedatum;
        }
        return $this;
    }
    /**
     * Get Geboorteplaats value
     * @return string|null
     */
    public function getGeboorteplaats()
    {
        return $this->Geboorteplaats;
    }
    /**
     * Set Geboorteplaats value
     * @param string $geboorteplaats
     * @return \StructType\LeadGegevens
     */
    public function setGeboorteplaats($geboorteplaats = null)
    {
        // validation for constraint: string
        if (!is_null($geboorteplaats) && !is_string($geboorteplaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geboorteplaats)), __LINE__);
        }
        $this->Geboorteplaats = $geboorteplaats;
        return $this;
    }
    /**
     * Get Geslacht value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeslacht()
    {
        return isset($this->Geslacht) ? $this->Geslacht : null;
    }
    /**
     * Set Geslacht value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\GeslachtType::valueIsValid()
     * @uses \EnumType\GeslachtType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geslacht
     * @return \StructType\LeadGegevens
     */
    public function setGeslacht($geslacht = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GeslachtType::valueIsValid($geslacht)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geslacht, implode(', ', \EnumType\GeslachtType::getValidValues())), __LINE__);
        }
        if (is_null($geslacht) || (is_array($geslacht) && empty($geslacht))) {
            unset($this->Geslacht);
        } else {
            $this->Geslacht = $geslacht;
        }
        return $this;
    }
    /**
     * Get Huisnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHuisnummer()
    {
        return isset($this->Huisnummer) ? $this->Huisnummer : null;
    }
    /**
     * Set Huisnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $huisnummer
     * @return \StructType\LeadGegevens
     */
    public function setHuisnummer($huisnummer = null)
    {
        // validation for constraint: int
        if (!is_null($huisnummer) && !is_numeric($huisnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($huisnummer)), __LINE__);
        }
        if (is_null($huisnummer) || (is_array($huisnummer) && empty($huisnummer))) {
            unset($this->Huisnummer);
        } else {
            $this->Huisnummer = $huisnummer;
        }
        return $this;
    }
    /**
     * Get Land value
     * @return string|null
     */
    public function getLand()
    {
        return $this->Land;
    }
    /**
     * Set Land value
     * @param string $land
     * @return \StructType\LeadGegevens
     */
    public function setLand($land = null)
    {
        // validation for constraint: string
        if (!is_null($land) && !is_string($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($land)), __LINE__);
        }
        $this->Land = $land;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\LeadGegevens
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get TelefoonnummerMobiel value
     * @return string|null
     */
    public function getTelefoonnummerMobiel()
    {
        return $this->TelefoonnummerMobiel;
    }
    /**
     * Set TelefoonnummerMobiel value
     * @param string $telefoonnummerMobiel
     * @return \StructType\LeadGegevens
     */
    public function setTelefoonnummerMobiel($telefoonnummerMobiel = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonnummerMobiel) && !is_string($telefoonnummerMobiel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefoonnummerMobiel)), __LINE__);
        }
        $this->TelefoonnummerMobiel = $telefoonnummerMobiel;
        return $this;
    }
    /**
     * Get TelefoonnummerPrive value
     * @return string|null
     */
    public function getTelefoonnummerPrive()
    {
        return $this->TelefoonnummerPrive;
    }
    /**
     * Set TelefoonnummerPrive value
     * @param string $telefoonnummerPrive
     * @return \StructType\LeadGegevens
     */
    public function setTelefoonnummerPrive($telefoonnummerPrive = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonnummerPrive) && !is_string($telefoonnummerPrive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefoonnummerPrive)), __LINE__);
        }
        $this->TelefoonnummerPrive = $telefoonnummerPrive;
        return $this;
    }
    /**
     * Get TelefoonnummerZakelijk value
     * @return string|null
     */
    public function getTelefoonnummerZakelijk()
    {
        return $this->TelefoonnummerZakelijk;
    }
    /**
     * Set TelefoonnummerZakelijk value
     * @param string $telefoonnummerZakelijk
     * @return \StructType\LeadGegevens
     */
    public function setTelefoonnummerZakelijk($telefoonnummerZakelijk = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonnummerZakelijk) && !is_string($telefoonnummerZakelijk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefoonnummerZakelijk)), __LINE__);
        }
        $this->TelefoonnummerZakelijk = $telefoonnummerZakelijk;
        return $this;
    }
    /**
     * Get Toevoeging value
     * @return string|null
     */
    public function getToevoeging()
    {
        return $this->Toevoeging;
    }
    /**
     * Set Toevoeging value
     * @param string $toevoeging
     * @return \StructType\LeadGegevens
     */
    public function setToevoeging($toevoeging = null)
    {
        // validation for constraint: string
        if (!is_null($toevoeging) && !is_string($toevoeging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toevoeging)), __LINE__);
        }
        $this->Toevoeging = $toevoeging;
        return $this;
    }
    /**
     * Get Tussenvoegsel value
     * @return string|null
     */
    public function getTussenvoegsel()
    {
        return $this->Tussenvoegsel;
    }
    /**
     * Set Tussenvoegsel value
     * @param string $tussenvoegsel
     * @return \StructType\LeadGegevens
     */
    public function setTussenvoegsel($tussenvoegsel = null)
    {
        // validation for constraint: string
        if (!is_null($tussenvoegsel) && !is_string($tussenvoegsel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tussenvoegsel)), __LINE__);
        }
        $this->Tussenvoegsel = $tussenvoegsel;
        return $this;
    }
    /**
     * Get InkomenPerMaand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInkomenPerMaand()
    {
        return isset($this->InkomenPerMaand) ? $this->InkomenPerMaand : null;
    }
    /**
     * Set InkomenPerMaand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inkomenPerMaand
     * @return \StructType\LeadGegevens
     */
    public function setInkomenPerMaand($inkomenPerMaand = null)
    {
        // validation for constraint: int
        if (!is_null($inkomenPerMaand) && !is_numeric($inkomenPerMaand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inkomenPerMaand)), __LINE__);
        }
        if (is_null($inkomenPerMaand) || (is_array($inkomenPerMaand) && empty($inkomenPerMaand))) {
            unset($this->InkomenPerMaand);
        } else {
            $this->InkomenPerMaand = $inkomenPerMaand;
        }
        return $this;
    }
    /**
     * Get AantalKinderen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantalKinderen()
    {
        return isset($this->AantalKinderen) ? $this->AantalKinderen : null;
    }
    /**
     * Set AantalKinderen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantalKinderen
     * @return \StructType\LeadGegevens
     */
    public function setAantalKinderen($aantalKinderen = null)
    {
        // validation for constraint: int
        if (!is_null($aantalKinderen) && !is_numeric($aantalKinderen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aantalKinderen)), __LINE__);
        }
        if (is_null($aantalKinderen) || (is_array($aantalKinderen) && empty($aantalKinderen))) {
            unset($this->AantalKinderen);
        } else {
            $this->AantalKinderen = $aantalKinderen;
        }
        return $this;
    }
    /**
     * Get AantalVolwassenen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantalVolwassenen()
    {
        return isset($this->AantalVolwassenen) ? $this->AantalVolwassenen : null;
    }
    /**
     * Set AantalVolwassenen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantalVolwassenen
     * @return \StructType\LeadGegevens
     */
    public function setAantalVolwassenen($aantalVolwassenen = null)
    {
        // validation for constraint: int
        if (!is_null($aantalVolwassenen) && !is_numeric($aantalVolwassenen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aantalVolwassenen)), __LINE__);
        }
        if (is_null($aantalVolwassenen) || (is_array($aantalVolwassenen) && empty($aantalVolwassenen))) {
            unset($this->AantalVolwassenen);
        } else {
            $this->AantalVolwassenen = $aantalVolwassenen;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LeadGegevens
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
