<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebMagazaStok StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebMagazaStok
 * @subpackage Structs
 */
class WebMagazaStok extends AbstractStructBase
{
    /**
     * The EksiStokAdedi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $EksiStokAdedi;
    /**
     * The MagazaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MagazaID;
    /**
     * The MagazaKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MagazaKodu;
    /**
     * The StokAdedi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $StokAdedi;
    /**
     * The TedarikciKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TedarikciKodu;
    /**
     * The UrunID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunID;
    /**
     * The UrunKartiID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiID;
    /**
     * Constructor method for WebMagazaStok
     * @uses WebMagazaStok::setEksiStokAdedi()
     * @uses WebMagazaStok::setMagazaID()
     * @uses WebMagazaStok::setMagazaKodu()
     * @uses WebMagazaStok::setStokAdedi()
     * @uses WebMagazaStok::setTedarikciKodu()
     * @uses WebMagazaStok::setUrunID()
     * @uses WebMagazaStok::setUrunKartiID()
     * @param float $eksiStokAdedi
     * @param int $magazaID
     * @param string $magazaKodu
     * @param float $stokAdedi
     * @param string $tedarikciKodu
     * @param int $urunID
     * @param int $urunKartiID
     */
    public function __construct($eksiStokAdedi = null, $magazaID = null, $magazaKodu = null, $stokAdedi = null, $tedarikciKodu = null, $urunID = null, $urunKartiID = null)
    {
        $this
            ->setEksiStokAdedi($eksiStokAdedi)
            ->setMagazaID($magazaID)
            ->setMagazaKodu($magazaKodu)
            ->setStokAdedi($stokAdedi)
            ->setTedarikciKodu($tedarikciKodu)
            ->setUrunID($urunID)
            ->setUrunKartiID($urunKartiID);
    }
    /**
     * Get EksiStokAdedi value
     * @return float|null
     */
    public function getEksiStokAdedi()
    {
        return $this->EksiStokAdedi;
    }
    /**
     * Set EksiStokAdedi value
     * @param float $eksiStokAdedi
     * @return \StructType\WebMagazaStok
     */
    public function setEksiStokAdedi($eksiStokAdedi = null)
    {
        // validation for constraint: float
        if (!is_null($eksiStokAdedi) && !(is_float($eksiStokAdedi) || is_numeric($eksiStokAdedi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eksiStokAdedi, true), gettype($eksiStokAdedi)), __LINE__);
        }
        $this->EksiStokAdedi = $eksiStokAdedi;
        return $this;
    }
    /**
     * Get MagazaID value
     * @return int|null
     */
    public function getMagazaID()
    {
        return $this->MagazaID;
    }
    /**
     * Set MagazaID value
     * @param int $magazaID
     * @return \StructType\WebMagazaStok
     */
    public function setMagazaID($magazaID = null)
    {
        // validation for constraint: int
        if (!is_null($magazaID) && !(is_int($magazaID) || ctype_digit($magazaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($magazaID, true), gettype($magazaID)), __LINE__);
        }
        $this->MagazaID = $magazaID;
        return $this;
    }
    /**
     * Get MagazaKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMagazaKodu()
    {
        return isset($this->MagazaKodu) ? $this->MagazaKodu : null;
    }
    /**
     * Set MagazaKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $magazaKodu
     * @return \StructType\WebMagazaStok
     */
    public function setMagazaKodu($magazaKodu = null)
    {
        // validation for constraint: string
        if (!is_null($magazaKodu) && !is_string($magazaKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magazaKodu, true), gettype($magazaKodu)), __LINE__);
        }
        if (is_null($magazaKodu) || (is_array($magazaKodu) && empty($magazaKodu))) {
            unset($this->MagazaKodu);
        } else {
            $this->MagazaKodu = $magazaKodu;
        }
        return $this;
    }
    /**
     * Get StokAdedi value
     * @return float|null
     */
    public function getStokAdedi()
    {
        return $this->StokAdedi;
    }
    /**
     * Set StokAdedi value
     * @param float $stokAdedi
     * @return \StructType\WebMagazaStok
     */
    public function setStokAdedi($stokAdedi = null)
    {
        // validation for constraint: float
        if (!is_null($stokAdedi) && !(is_float($stokAdedi) || is_numeric($stokAdedi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($stokAdedi, true), gettype($stokAdedi)), __LINE__);
        }
        $this->StokAdedi = $stokAdedi;
        return $this;
    }
    /**
     * Get TedarikciKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTedarikciKodu()
    {
        return isset($this->TedarikciKodu) ? $this->TedarikciKodu : null;
    }
    /**
     * Set TedarikciKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tedarikciKodu
     * @return \StructType\WebMagazaStok
     */
    public function setTedarikciKodu($tedarikciKodu = null)
    {
        // validation for constraint: string
        if (!is_null($tedarikciKodu) && !is_string($tedarikciKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tedarikciKodu, true), gettype($tedarikciKodu)), __LINE__);
        }
        if (is_null($tedarikciKodu) || (is_array($tedarikciKodu) && empty($tedarikciKodu))) {
            unset($this->TedarikciKodu);
        } else {
            $this->TedarikciKodu = $tedarikciKodu;
        }
        return $this;
    }
    /**
     * Get UrunID value
     * @return int|null
     */
    public function getUrunID()
    {
        return $this->UrunID;
    }
    /**
     * Set UrunID value
     * @param int $urunID
     * @return \StructType\WebMagazaStok
     */
    public function setUrunID($urunID = null)
    {
        // validation for constraint: int
        if (!is_null($urunID) && !(is_int($urunID) || ctype_digit($urunID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunID, true), gettype($urunID)), __LINE__);
        }
        $this->UrunID = $urunID;
        return $this;
    }
    /**
     * Get UrunKartiID value
     * @return int|null
     */
    public function getUrunKartiID()
    {
        return $this->UrunKartiID;
    }
    /**
     * Set UrunKartiID value
     * @param int $urunKartiID
     * @return \StructType\WebMagazaStok
     */
    public function setUrunKartiID($urunKartiID = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiID) && !(is_int($urunKartiID) || ctype_digit($urunKartiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKartiID, true), gettype($urunKartiID)), __LINE__);
        }
        $this->UrunKartiID = $urunKartiID;
        return $this;
    }
}
