<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TakimUrun StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TakimUrun
 * @subpackage Structs
 */
class TakimUrun extends AbstractStructBase
{
    /**
     * The Adet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Adet;
    /**
     * The Secili
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Secili;
    /**
     * The Sira
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sira;
    /**
     * The TedarikciKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TedarikciKodu;
    /**
     * Constructor method for TakimUrun
     * @uses TakimUrun::setAdet()
     * @uses TakimUrun::setSecili()
     * @uses TakimUrun::setSira()
     * @uses TakimUrun::setTedarikciKodu()
     * @param float $adet
     * @param bool $secili
     * @param int $sira
     * @param string $tedarikciKodu
     */
    public function __construct($adet = null, $secili = null, $sira = null, $tedarikciKodu = null)
    {
        $this
            ->setAdet($adet)
            ->setSecili($secili)
            ->setSira($sira)
            ->setTedarikciKodu($tedarikciKodu);
    }
    /**
     * Get Adet value
     * @return float|null
     */
    public function getAdet()
    {
        return $this->Adet;
    }
    /**
     * Set Adet value
     * @param float $adet
     * @return \StructType\TakimUrun
     */
    public function setAdet($adet = null)
    {
        // validation for constraint: float
        if (!is_null($adet) && !(is_float($adet) || is_numeric($adet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adet, true), gettype($adet)), __LINE__);
        }
        $this->Adet = $adet;
        return $this;
    }
    /**
     * Get Secili value
     * @return bool|null
     */
    public function getSecili()
    {
        return $this->Secili;
    }
    /**
     * Set Secili value
     * @param bool $secili
     * @return \StructType\TakimUrun
     */
    public function setSecili($secili = null)
    {
        // validation for constraint: boolean
        if (!is_null($secili) && !is_bool($secili)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($secili, true), gettype($secili)), __LINE__);
        }
        $this->Secili = $secili;
        return $this;
    }
    /**
     * Get Sira value
     * @return int|null
     */
    public function getSira()
    {
        return $this->Sira;
    }
    /**
     * Set Sira value
     * @param int $sira
     * @return \StructType\TakimUrun
     */
    public function setSira($sira = null)
    {
        // validation for constraint: int
        if (!is_null($sira) && !(is_int($sira) || ctype_digit($sira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sira, true), gettype($sira)), __LINE__);
        }
        $this->Sira = $sira;
        return $this;
    }
    /**
     * Get TedarikciKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTedarikciKodu()
    {
        return isset($this->TedarikciKodu) ? $this->TedarikciKodu : null;
    }
    /**
     * Set TedarikciKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tedarikciKodu
     * @return \StructType\TakimUrun
     */
    public function setTedarikciKodu($tedarikciKodu = null)
    {
        // validation for constraint: string
        if (!is_null($tedarikciKodu) && !is_string($tedarikciKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tedarikciKodu, true), gettype($tedarikciKodu)), __LINE__);
        }
        if (is_null($tedarikciKodu) || (is_array($tedarikciKodu) && empty($tedarikciKodu))) {
            unset($this->TedarikciKodu);
        } else {
            $this->TedarikciKodu = $tedarikciKodu;
        }
        return $this;
    }
}
