<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Stok ServiceType
 * @subpackage Services
 */
class Stok extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named StokAdediGuncelle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StokAdediGuncelle $parameters
     * @return \StructType\StokAdediGuncelleResponse|bool
     */
    public function StokAdediGuncelle(\StructType\StokAdediGuncelle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StokAdediGuncelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StokAdediGuncelleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
