<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTaksitSecenekleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTaksitSecenekleri $parameters
     * @return \StructType\GetTaksitSecenekleriResponse|bool
     */
    public function GetTaksitSecenekleri(\StructType\GetTaksitSecenekleri $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTaksitSecenekleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductStatus $parameters
     * @return \StructType\GetProductStatusResponse|bool
     */
    public function GetProductStatus(\StructType\GetProductStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProductStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetProductStatusResponse|\StructType\GetTaksitSecenekleriResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
