<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendMmsSubmission
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticationInfo $authentication
     * @param \StructType\MmsSubmission $submission
     * @return \StructType\SubmissionStatus|bool
     */
    public function sendMmsSubmission(\StructType\AuthenticationInfo $authentication, \StructType\MmsSubmission $submission)
    {
        try {
            $this->setResult($this->getSoapClient()->sendMmsSubmission($authentication, $submission));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSmsPullSubmission
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticationInfo $authentication
     * @param \StructType\SmsPullSubmission $submission
     * @return \StructType\SubmissionStatus|bool
     */
    public function sendSmsPullSubmission(\StructType\AuthenticationInfo $authentication, \StructType\SmsPullSubmission $submission)
    {
        try {
            $this->setResult($this->getSoapClient()->sendSmsPullSubmission($authentication, $submission));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSmsSubmission
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticationInfo $authentication
     * @param \StructType\SmsSubmission $submission
     * @return \StructType\SubmissionStatus|bool
     */
    public function sendSmsSubmission(\StructType\AuthenticationInfo $authentication, \StructType\SmsSubmission $submission)
    {
        try {
            $this->setResult($this->getSoapClient()->sendSmsSubmission($authentication, $submission));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendWapPushSubmission
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticationInfo $authentication
     * @param \StructType\WapPushSubmission $submission
     * @return \StructType\SubmissionStatus|bool
     */
    public function sendWapPushSubmission(\StructType\AuthenticationInfo $authentication, \StructType\WapPushSubmission $submission)
    {
        try {
            $this->setResult($this->getSoapClient()->sendWapPushSubmission($authentication, $submission));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SubmissionStatus
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
