<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOf_xsd_waiting ArrayType
 * @subpackage Arrays
 */
class ArrayOf_xsd_waiting extends AbstractStructArrayBase
{
    /**
     * The waiting
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $waiting;
    /**
     * Constructor method for ArrayOf_xsd_waiting
     * @uses ArrayOf_xsd_waiting::setWaiting()
     * @param string[] $waiting
     */
    public function __construct(array $waiting = array())
    {
        $this
            ->setWaiting($waiting);
    }
    /**
     * Get waiting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getWaiting()
    {
        return isset($this->waiting) ? $this->waiting : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWaiting method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWaiting method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWaitingForArrayConstraintsFromSetWaiting(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOf_xsd_waitingWaitingItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOf_xsd_waitingWaitingItem)) {
                $invalidValues[] = is_object($arrayOf_xsd_waitingWaitingItem) ? get_class($arrayOf_xsd_waitingWaitingItem) : sprintf('%s(%s)', gettype($arrayOf_xsd_waitingWaitingItem), var_export($arrayOf_xsd_waitingWaitingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The waiting property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set waiting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $waiting
     * @return \ArrayType\ArrayOf_xsd_waiting
     */
    public function setWaiting(array $waiting = array())
    {
        // validation for constraint: array
        if ('' !== ($waitingArrayErrorMessage = self::validateWaitingForArrayConstraintsFromSetWaiting($waiting))) {
            throw new \InvalidArgumentException($waitingArrayErrorMessage, __LINE__);
        }
        if (is_null($waiting) || (is_array($waiting) && empty($waiting))) {
            unset($this->waiting);
        } else {
            $this->waiting = $waiting;
        }
        return $this;
    }
    /**
     * Add item to waiting value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOf_xsd_waiting
     */
    public function addToWaiting($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The waiting property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->waiting[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string waiting
     */
    public function getAttributeName()
    {
        return 'waiting';
    }
}
