<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOf_xsd_delivered ArrayType
 * @subpackage Arrays
 */
class ArrayOf_xsd_delivered extends AbstractStructArrayBase
{
    /**
     * The delivered
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $delivered;
    /**
     * Constructor method for ArrayOf_xsd_delivered
     * @uses ArrayOf_xsd_delivered::setDelivered()
     * @param string[] $delivered
     */
    public function __construct(array $delivered = array())
    {
        $this
            ->setDelivered($delivered);
    }
    /**
     * Get delivered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getDelivered()
    {
        return isset($this->delivered) ? $this->delivered : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDelivered method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivered method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveredForArrayConstraintsFromSetDelivered(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOf_xsd_deliveredDeliveredItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOf_xsd_deliveredDeliveredItem)) {
                $invalidValues[] = is_object($arrayOf_xsd_deliveredDeliveredItem) ? get_class($arrayOf_xsd_deliveredDeliveredItem) : sprintf('%s(%s)', gettype($arrayOf_xsd_deliveredDeliveredItem), var_export($arrayOf_xsd_deliveredDeliveredItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The delivered property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set delivered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $delivered
     * @return \ArrayType\ArrayOf_xsd_delivered
     */
    public function setDelivered(array $delivered = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveredArrayErrorMessage = self::validateDeliveredForArrayConstraintsFromSetDelivered($delivered))) {
            throw new \InvalidArgumentException($deliveredArrayErrorMessage, __LINE__);
        }
        if (is_null($delivered) || (is_array($delivered) && empty($delivered))) {
            unset($this->delivered);
        } else {
            $this->delivered = $delivered;
        }
        return $this;
    }
    /**
     * Add item to delivered value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOf_xsd_delivered
     */
    public function addToDelivered($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The delivered property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->delivered[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string delivered
     */
    public function getAttributeName()
    {
        return 'delivered';
    }
}
