<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOf_xsd_canceled ArrayType
 * @subpackage Arrays
 */
class ArrayOf_xsd_canceled extends AbstractStructArrayBase
{
    /**
     * The canceled
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $canceled;
    /**
     * Constructor method for ArrayOf_xsd_canceled
     * @uses ArrayOf_xsd_canceled::setCanceled()
     * @param string[] $canceled
     */
    public function __construct(array $canceled = array())
    {
        $this
            ->setCanceled($canceled);
    }
    /**
     * Get canceled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCanceled()
    {
        return isset($this->canceled) ? $this->canceled : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCanceled method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCanceled method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCanceledForArrayConstraintsFromSetCanceled(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOf_xsd_canceledCanceledItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOf_xsd_canceledCanceledItem)) {
                $invalidValues[] = is_object($arrayOf_xsd_canceledCanceledItem) ? get_class($arrayOf_xsd_canceledCanceledItem) : sprintf('%s(%s)', gettype($arrayOf_xsd_canceledCanceledItem), var_export($arrayOf_xsd_canceledCanceledItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The canceled property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set canceled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $canceled
     * @return \ArrayType\ArrayOf_xsd_canceled
     */
    public function setCanceled(array $canceled = array())
    {
        // validation for constraint: array
        if ('' !== ($canceledArrayErrorMessage = self::validateCanceledForArrayConstraintsFromSetCanceled($canceled))) {
            throw new \InvalidArgumentException($canceledArrayErrorMessage, __LINE__);
        }
        if (is_null($canceled) || (is_array($canceled) && empty($canceled))) {
            unset($this->canceled);
        } else {
            $this->canceled = $canceled;
        }
        return $this;
    }
    /**
     * Add item to canceled value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOf_xsd_canceled
     */
    public function addToCanceled($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The canceled property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->canceled[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string canceled
     */
    public function getAttributeName()
    {
        return 'canceled';
    }
}
