<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOf_xsd_ContactLists ArrayType
 * @subpackage Arrays
 */
class ArrayOf_xsd_ContactLists extends AbstractStructArrayBase
{
    /**
     * The contactlists
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $contactlists;
    /**
     * Constructor method for ArrayOf_xsd_ContactLists
     * @uses ArrayOf_xsd_ContactLists::setContactlists()
     * @param string[] $contactlists
     */
    public function __construct(array $contactlists = array())
    {
        $this
            ->setContactlists($contactlists);
    }
    /**
     * Get contactlists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getContactlists()
    {
        return isset($this->contactlists) ? $this->contactlists : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContactlists method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactlists method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactlistsForArrayConstraintsFromSetContactlists(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOf_xsd_ContactListsContactlistsItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOf_xsd_ContactListsContactlistsItem)) {
                $invalidValues[] = is_object($arrayOf_xsd_ContactListsContactlistsItem) ? get_class($arrayOf_xsd_ContactListsContactlistsItem) : sprintf('%s(%s)', gettype($arrayOf_xsd_ContactListsContactlistsItem), var_export($arrayOf_xsd_ContactListsContactlistsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contactlists property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contactlists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $contactlists
     * @return \ArrayType\ArrayOf_xsd_ContactLists
     */
    public function setContactlists(array $contactlists = array())
    {
        // validation for constraint: array
        if ('' !== ($contactlistsArrayErrorMessage = self::validateContactlistsForArrayConstraintsFromSetContactlists($contactlists))) {
            throw new \InvalidArgumentException($contactlistsArrayErrorMessage, __LINE__);
        }
        if (is_null($contactlists) || (is_array($contactlists) && empty($contactlists))) {
            unset($this->contactlists);
        } else {
            $this->contactlists = $contactlists;
        }
        return $this;
    }
    /**
     * Add item to contactlists value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOf_xsd_ContactLists
     */
    public function addToContactlists($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The contactlists property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contactlists[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string contactlists
     */
    public function getAttributeName()
    {
        return 'contactlists';
    }
}
