<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArrayOf_xsd_substitutions ArrayType
 * @subpackage Arrays
 */
class ArrayOfArrayOf_xsd_substitutions extends AbstractStructArrayBase
{
    /**
     * The substitutions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOf_xsd_substitution[]
     */
    public $substitutions;
    /**
     * Constructor method for ArrayOfArrayOf_xsd_substitutions
     * @uses ArrayOfArrayOf_xsd_substitutions::setSubstitutions()
     * @param \ArrayType\ArrayOf_xsd_substitution[] $substitutions
     */
    public function __construct(array $substitutions = array())
    {
        $this
            ->setSubstitutions($substitutions);
    }
    /**
     * Get substitutions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOf_xsd_substitution[]|null
     */
    public function getSubstitutions()
    {
        return isset($this->substitutions) ? $this->substitutions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubstitutions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubstitutions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubstitutionsForArrayConstraintsFromSetSubstitutions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfArrayOf_xsd_substitutionsSubstitutionsItem) {
            // validation for constraint: itemType
            if (!$arrayOfArrayOf_xsd_substitutionsSubstitutionsItem instanceof \ArrayType\ArrayOf_xsd_substitution) {
                $invalidValues[] = is_object($arrayOfArrayOf_xsd_substitutionsSubstitutionsItem) ? get_class($arrayOfArrayOf_xsd_substitutionsSubstitutionsItem) : sprintf('%s(%s)', gettype($arrayOfArrayOf_xsd_substitutionsSubstitutionsItem), var_export($arrayOfArrayOf_xsd_substitutionsSubstitutionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The substitutions property can only contain items of type \ArrayType\ArrayOf_xsd_substitution, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set substitutions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ArrayType\ArrayOf_xsd_substitution[] $substitutions
     * @return \ArrayType\ArrayOfArrayOf_xsd_substitutions
     */
    public function setSubstitutions(array $substitutions = array())
    {
        // validation for constraint: array
        if ('' !== ($substitutionsArrayErrorMessage = self::validateSubstitutionsForArrayConstraintsFromSetSubstitutions($substitutions))) {
            throw new \InvalidArgumentException($substitutionsArrayErrorMessage, __LINE__);
        }
        if (is_null($substitutions) || (is_array($substitutions) && empty($substitutions))) {
            unset($this->substitutions);
        } else {
            $this->substitutions = $substitutions;
        }
        return $this;
    }
    /**
     * Add item to substitutions value
     * @throws \InvalidArgumentException
     * @param \ArrayType\ArrayOf_xsd_substitution $item
     * @return \ArrayType\ArrayOfArrayOf_xsd_substitutions
     */
    public function addToSubstitutions(\ArrayType\ArrayOf_xsd_substitution $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ArrayType\ArrayOf_xsd_substitution) {
            throw new \InvalidArgumentException(sprintf('The substitutions property can only contain items of type \ArrayType\ArrayOf_xsd_substitution, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->substitutions[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ArrayType\ArrayOf_xsd_substitution|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ArrayType\ArrayOf_xsd_substitution|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ArrayType\ArrayOf_xsd_substitution|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ArrayType\ArrayOf_xsd_substitution|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ArrayType\ArrayOf_xsd_substitution|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string substitutions
     */
    public function getAttributeName()
    {
        return 'substitutions';
    }
}
