<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmissionDetails StructType
 * @subpackage Structs
 */
class SubmissionDetails extends AbstractStructBase
{
    /**
     * The canceledMessages
     * @var int
     */
    public $canceledMessages;
    /**
     * The creationDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $creationDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $endDate;
    /**
     * The failedMessages
     * @var int
     */
    public $failedMessages;
    /**
     * The link
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $link;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $message;
    /**
     * The messageType
     * @var int
     */
    public $messageType;
    /**
     * The notifWaitMessages
     * @var int
     */
    public $notifWaitMessages;
    /**
     * The notificationRequested
     * @var bool
     */
    public $notificationRequested;
    /**
     * The originator
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $originator;
    /**
     * The processStatus
     * @var int
     */
    public $processStatus;
    /**
     * The recipientsStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\RecipientsStatus
     */
    public $recipientsStatus;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sender;
    /**
     * The sentMessages
     * @var int
     */
    public $sentMessages;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $startDate;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The submissionId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $submissionId;
    /**
     * The totalMessages
     * @var int
     */
    public $totalMessages;
    /**
     * The waitMessages
     * @var int
     */
    public $waitMessages;
    /**
     * Constructor method for SubmissionDetails
     * @uses SubmissionDetails::setCanceledMessages()
     * @uses SubmissionDetails::setCreationDate()
     * @uses SubmissionDetails::setEndDate()
     * @uses SubmissionDetails::setFailedMessages()
     * @uses SubmissionDetails::setLink()
     * @uses SubmissionDetails::setMessage()
     * @uses SubmissionDetails::setMessageType()
     * @uses SubmissionDetails::setNotifWaitMessages()
     * @uses SubmissionDetails::setNotificationRequested()
     * @uses SubmissionDetails::setOriginator()
     * @uses SubmissionDetails::setProcessStatus()
     * @uses SubmissionDetails::setRecipientsStatus()
     * @uses SubmissionDetails::setSender()
     * @uses SubmissionDetails::setSentMessages()
     * @uses SubmissionDetails::setStartDate()
     * @uses SubmissionDetails::setStatus()
     * @uses SubmissionDetails::setSubmissionId()
     * @uses SubmissionDetails::setTotalMessages()
     * @uses SubmissionDetails::setWaitMessages()
     * @param int $canceledMessages
     * @param string $creationDate
     * @param string $endDate
     * @param int $failedMessages
     * @param string $link
     * @param string $message
     * @param int $messageType
     * @param int $notifWaitMessages
     * @param bool $notificationRequested
     * @param string $originator
     * @param int $processStatus
     * @param \StructType\RecipientsStatus $recipientsStatus
     * @param string $sender
     * @param int $sentMessages
     * @param string $startDate
     * @param int $status
     * @param string $submissionId
     * @param int $totalMessages
     * @param int $waitMessages
     */
    public function __construct($canceledMessages = null, $creationDate = null, $endDate = null, $failedMessages = null, $link = null, $message = null, $messageType = null, $notifWaitMessages = null, $notificationRequested = null, $originator = null, $processStatus = null, \StructType\RecipientsStatus $recipientsStatus = null, $sender = null, $sentMessages = null, $startDate = null, $status = null, $submissionId = null, $totalMessages = null, $waitMessages = null)
    {
        $this
            ->setCanceledMessages($canceledMessages)
            ->setCreationDate($creationDate)
            ->setEndDate($endDate)
            ->setFailedMessages($failedMessages)
            ->setLink($link)
            ->setMessage($message)
            ->setMessageType($messageType)
            ->setNotifWaitMessages($notifWaitMessages)
            ->setNotificationRequested($notificationRequested)
            ->setOriginator($originator)
            ->setProcessStatus($processStatus)
            ->setRecipientsStatus($recipientsStatus)
            ->setSender($sender)
            ->setSentMessages($sentMessages)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setSubmissionId($submissionId)
            ->setTotalMessages($totalMessages)
            ->setWaitMessages($waitMessages);
    }
    /**
     * Get canceledMessages value
     * @return int|null
     */
    public function getCanceledMessages()
    {
        return $this->canceledMessages;
    }
    /**
     * Set canceledMessages value
     * @param int $canceledMessages
     * @return \StructType\SubmissionDetails
     */
    public function setCanceledMessages($canceledMessages = null)
    {
        // validation for constraint: int
        if (!is_null($canceledMessages) && !(is_int($canceledMessages) || ctype_digit($canceledMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($canceledMessages, true), gettype($canceledMessages)), __LINE__);
        }
        $this->canceledMessages = $canceledMessages;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \StructType\SubmissionDetails
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\SubmissionDetails
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get failedMessages value
     * @return int|null
     */
    public function getFailedMessages()
    {
        return $this->failedMessages;
    }
    /**
     * Set failedMessages value
     * @param int $failedMessages
     * @return \StructType\SubmissionDetails
     */
    public function setFailedMessages($failedMessages = null)
    {
        // validation for constraint: int
        if (!is_null($failedMessages) && !(is_int($failedMessages) || ctype_digit($failedMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedMessages, true), gettype($failedMessages)), __LINE__);
        }
        $this->failedMessages = $failedMessages;
        return $this;
    }
    /**
     * Get link value
     * @return string|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param string $link
     * @return \StructType\SubmissionDetails
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($link, true), gettype($link)), __LINE__);
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\SubmissionDetails
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get messageType value
     * @return int|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param int $messageType
     * @return \StructType\SubmissionDetails
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: int
        if (!is_null($messageType) && !(is_int($messageType) || ctype_digit($messageType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageType, true), gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get notifWaitMessages value
     * @return int|null
     */
    public function getNotifWaitMessages()
    {
        return $this->notifWaitMessages;
    }
    /**
     * Set notifWaitMessages value
     * @param int $notifWaitMessages
     * @return \StructType\SubmissionDetails
     */
    public function setNotifWaitMessages($notifWaitMessages = null)
    {
        // validation for constraint: int
        if (!is_null($notifWaitMessages) && !(is_int($notifWaitMessages) || ctype_digit($notifWaitMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($notifWaitMessages, true), gettype($notifWaitMessages)), __LINE__);
        }
        $this->notifWaitMessages = $notifWaitMessages;
        return $this;
    }
    /**
     * Get notificationRequested value
     * @return bool|null
     */
    public function getNotificationRequested()
    {
        return $this->notificationRequested;
    }
    /**
     * Set notificationRequested value
     * @param bool $notificationRequested
     * @return \StructType\SubmissionDetails
     */
    public function setNotificationRequested($notificationRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($notificationRequested) && !is_bool($notificationRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notificationRequested, true), gettype($notificationRequested)), __LINE__);
        }
        $this->notificationRequested = $notificationRequested;
        return $this;
    }
    /**
     * Get originator value
     * @return string|null
     */
    public function getOriginator()
    {
        return $this->originator;
    }
    /**
     * Set originator value
     * @param string $originator
     * @return \StructType\SubmissionDetails
     */
    public function setOriginator($originator = null)
    {
        // validation for constraint: string
        if (!is_null($originator) && !is_string($originator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originator, true), gettype($originator)), __LINE__);
        }
        $this->originator = $originator;
        return $this;
    }
    /**
     * Get processStatus value
     * @return int|null
     */
    public function getProcessStatus()
    {
        return $this->processStatus;
    }
    /**
     * Set processStatus value
     * @param int $processStatus
     * @return \StructType\SubmissionDetails
     */
    public function setProcessStatus($processStatus = null)
    {
        // validation for constraint: int
        if (!is_null($processStatus) && !(is_int($processStatus) || ctype_digit($processStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processStatus, true), gettype($processStatus)), __LINE__);
        }
        $this->processStatus = $processStatus;
        return $this;
    }
    /**
     * Get recipientsStatus value
     * @return \StructType\RecipientsStatus|null
     */
    public function getRecipientsStatus()
    {
        return $this->recipientsStatus;
    }
    /**
     * Set recipientsStatus value
     * @param \StructType\RecipientsStatus $recipientsStatus
     * @return \StructType\SubmissionDetails
     */
    public function setRecipientsStatus(\StructType\RecipientsStatus $recipientsStatus = null)
    {
        $this->recipientsStatus = $recipientsStatus;
        return $this;
    }
    /**
     * Get sender value
     * @return string|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param string $sender
     * @return \StructType\SubmissionDetails
     */
    public function setSender($sender = null)
    {
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender, true), gettype($sender)), __LINE__);
        }
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get sentMessages value
     * @return int|null
     */
    public function getSentMessages()
    {
        return $this->sentMessages;
    }
    /**
     * Set sentMessages value
     * @param int $sentMessages
     * @return \StructType\SubmissionDetails
     */
    public function setSentMessages($sentMessages = null)
    {
        // validation for constraint: int
        if (!is_null($sentMessages) && !(is_int($sentMessages) || ctype_digit($sentMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sentMessages, true), gettype($sentMessages)), __LINE__);
        }
        $this->sentMessages = $sentMessages;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\SubmissionDetails
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\SubmissionDetails
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get submissionId value
     * @return string|null
     */
    public function getSubmissionId()
    {
        return $this->submissionId;
    }
    /**
     * Set submissionId value
     * @param string $submissionId
     * @return \StructType\SubmissionDetails
     */
    public function setSubmissionId($submissionId = null)
    {
        // validation for constraint: string
        if (!is_null($submissionId) && !is_string($submissionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submissionId, true), gettype($submissionId)), __LINE__);
        }
        $this->submissionId = $submissionId;
        return $this;
    }
    /**
     * Get totalMessages value
     * @return int|null
     */
    public function getTotalMessages()
    {
        return $this->totalMessages;
    }
    /**
     * Set totalMessages value
     * @param int $totalMessages
     * @return \StructType\SubmissionDetails
     */
    public function setTotalMessages($totalMessages = null)
    {
        // validation for constraint: int
        if (!is_null($totalMessages) && !(is_int($totalMessages) || ctype_digit($totalMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMessages, true), gettype($totalMessages)), __LINE__);
        }
        $this->totalMessages = $totalMessages;
        return $this;
    }
    /**
     * Get waitMessages value
     * @return int|null
     */
    public function getWaitMessages()
    {
        return $this->waitMessages;
    }
    /**
     * Set waitMessages value
     * @param int $waitMessages
     * @return \StructType\SubmissionDetails
     */
    public function setWaitMessages($waitMessages = null)
    {
        // validation for constraint: int
        if (!is_null($waitMessages) && !(is_int($waitMessages) || ctype_digit($waitMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitMessages, true), gettype($waitMessages)), __LINE__);
        }
        $this->waitMessages = $waitMessages;
        return $this;
    }
}
