<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsSubmission StructType
 * @subpackage Structs
 */
class SmsSubmission extends Submission
{
    /**
     * The alphabet
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $alphabet;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $message;
    /**
     * The substitutions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfArrayOf_xsd_substitutions
     */
    public $substitutions;
    /**
     * The useSubstitutions
     * @var bool
     */
    public $useSubstitutions;
    /**
     * The smsClass
     * Meta information extracted from the WSDL
     * - default: -2147483648
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $smsClass;
    /**
     * Constructor method for SmsSubmission
     * @uses SmsSubmission::setAlphabet()
     * @uses SmsSubmission::setMessage()
     * @uses SmsSubmission::setSubstitutions()
     * @uses SmsSubmission::setUseSubstitutions()
     * @uses SmsSubmission::setSmsClass()
     * @param string $alphabet
     * @param string $message
     * @param \ArrayType\ArrayOfArrayOf_xsd_substitutions $substitutions
     * @param bool $useSubstitutions
     * @param int $smsClass
     */
    public function __construct($alphabet = null, $message = null, \ArrayType\ArrayOfArrayOf_xsd_substitutions $substitutions = null, $useSubstitutions = null, $smsClass = -2147483648)
    {
        $this
            ->setAlphabet($alphabet)
            ->setMessage($message)
            ->setSubstitutions($substitutions)
            ->setUseSubstitutions($useSubstitutions)
            ->setSmsClass($smsClass);
    }
    /**
     * Get alphabet value
     * @return string|null
     */
    public function getAlphabet()
    {
        return $this->alphabet;
    }
    /**
     * Set alphabet value
     * @param string $alphabet
     * @return \StructType\SmsSubmission
     */
    public function setAlphabet($alphabet = null)
    {
        // validation for constraint: string
        if (!is_null($alphabet) && !is_string($alphabet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alphabet, true), gettype($alphabet)), __LINE__);
        }
        $this->alphabet = $alphabet;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\SmsSubmission
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get substitutions value
     * @return \ArrayType\ArrayOfArrayOf_xsd_substitutions|null
     */
    public function getSubstitutions()
    {
        return $this->substitutions;
    }
    /**
     * Set substitutions value
     * @param \ArrayType\ArrayOfArrayOf_xsd_substitutions $substitutions
     * @return \StructType\SmsSubmission
     */
    public function setSubstitutions(\ArrayType\ArrayOfArrayOf_xsd_substitutions $substitutions = null)
    {
        $this->substitutions = $substitutions;
        return $this;
    }
    /**
     * Get useSubstitutions value
     * @return bool|null
     */
    public function getUseSubstitutions()
    {
        return $this->useSubstitutions;
    }
    /**
     * Set useSubstitutions value
     * @param bool $useSubstitutions
     * @return \StructType\SmsSubmission
     */
    public function setUseSubstitutions($useSubstitutions = null)
    {
        // validation for constraint: boolean
        if (!is_null($useSubstitutions) && !is_bool($useSubstitutions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useSubstitutions, true), gettype($useSubstitutions)), __LINE__);
        }
        $this->useSubstitutions = $useSubstitutions;
        return $this;
    }
    /**
     * Get smsClass value
     * @return int|null
     */
    public function getSmsClass()
    {
        return $this->smsClass;
    }
    /**
     * Set smsClass value
     * @param int $smsClass
     * @return \StructType\SmsSubmission
     */
    public function setSmsClass($smsClass = -2147483648)
    {
        // validation for constraint: int
        if (!is_null($smsClass) && !(is_int($smsClass) || ctype_digit($smsClass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($smsClass, true), gettype($smsClass)), __LINE__);
        }
        $this->smsClass = $smsClass;
        return $this;
    }
}
