<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsPullSubmission StructType
 * @subpackage Structs
 */
class SmsPullSubmission extends SmsSubmission
{
    /**
     * The acceptNonAddresseesResponses
     * @var bool
     */
    public $acceptNonAddresseesResponses;
    /**
     * The billingId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $billingId;
    /**
     * The responseAcceptedMessage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $responseAcceptedMessage;
    /**
     * The submissionCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $submissionCode;
    /**
     * The validUntil
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $validUntil;
    /**
     * Constructor method for SmsPullSubmission
     * @uses SmsPullSubmission::setAcceptNonAddresseesResponses()
     * @uses SmsPullSubmission::setBillingId()
     * @uses SmsPullSubmission::setResponseAcceptedMessage()
     * @uses SmsPullSubmission::setSubmissionCode()
     * @uses SmsPullSubmission::setValidUntil()
     * @param bool $acceptNonAddresseesResponses
     * @param string $billingId
     * @param string $responseAcceptedMessage
     * @param string $submissionCode
     * @param string $validUntil
     */
    public function __construct($acceptNonAddresseesResponses = null, $billingId = null, $responseAcceptedMessage = null, $submissionCode = null, $validUntil = null)
    {
        $this
            ->setAcceptNonAddresseesResponses($acceptNonAddresseesResponses)
            ->setBillingId($billingId)
            ->setResponseAcceptedMessage($responseAcceptedMessage)
            ->setSubmissionCode($submissionCode)
            ->setValidUntil($validUntil);
    }
    /**
     * Get acceptNonAddresseesResponses value
     * @return bool|null
     */
    public function getAcceptNonAddresseesResponses()
    {
        return $this->acceptNonAddresseesResponses;
    }
    /**
     * Set acceptNonAddresseesResponses value
     * @param bool $acceptNonAddresseesResponses
     * @return \StructType\SmsPullSubmission
     */
    public function setAcceptNonAddresseesResponses($acceptNonAddresseesResponses = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptNonAddresseesResponses) && !is_bool($acceptNonAddresseesResponses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acceptNonAddresseesResponses, true), gettype($acceptNonAddresseesResponses)), __LINE__);
        }
        $this->acceptNonAddresseesResponses = $acceptNonAddresseesResponses;
        return $this;
    }
    /**
     * Get billingId value
     * @return string|null
     */
    public function getBillingId()
    {
        return $this->billingId;
    }
    /**
     * Set billingId value
     * @param string $billingId
     * @return \StructType\SmsPullSubmission
     */
    public function setBillingId($billingId = null)
    {
        // validation for constraint: string
        if (!is_null($billingId) && !is_string($billingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingId, true), gettype($billingId)), __LINE__);
        }
        $this->billingId = $billingId;
        return $this;
    }
    /**
     * Get responseAcceptedMessage value
     * @return string|null
     */
    public function getResponseAcceptedMessage()
    {
        return $this->responseAcceptedMessage;
    }
    /**
     * Set responseAcceptedMessage value
     * @param string $responseAcceptedMessage
     * @return \StructType\SmsPullSubmission
     */
    public function setResponseAcceptedMessage($responseAcceptedMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseAcceptedMessage) && !is_string($responseAcceptedMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseAcceptedMessage, true), gettype($responseAcceptedMessage)), __LINE__);
        }
        $this->responseAcceptedMessage = $responseAcceptedMessage;
        return $this;
    }
    /**
     * Get submissionCode value
     * @return string|null
     */
    public function getSubmissionCode()
    {
        return $this->submissionCode;
    }
    /**
     * Set submissionCode value
     * @param string $submissionCode
     * @return \StructType\SmsPullSubmission
     */
    public function setSubmissionCode($submissionCode = null)
    {
        // validation for constraint: string
        if (!is_null($submissionCode) && !is_string($submissionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submissionCode, true), gettype($submissionCode)), __LINE__);
        }
        $this->submissionCode = $submissionCode;
        return $this;
    }
    /**
     * Get validUntil value
     * @return string|null
     */
    public function getValidUntil()
    {
        return $this->validUntil;
    }
    /**
     * Set validUntil value
     * @param string $validUntil
     * @return \StructType\SmsPullSubmission
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validUntil, true), gettype($validUntil)), __LINE__);
        }
        $this->validUntil = $validUntil;
        return $this;
    }
}
