<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmissionStatus2 StructType
 * @subpackage Structs
 */
class SubmissionStatus2 extends AbstractStructBase
{
    /**
     * The canceledMessages
     * @var int
     */
    public $canceledMessages;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $endDate;
    /**
     * The failedMessages
     * @var int
     */
    public $failedMessages;
    /**
     * The messageType
     * @var int
     */
    public $messageType;
    /**
     * The notifWaitMessages
     * @var int
     */
    public $notifWaitMessages;
    /**
     * The processStatus
     * @var int
     */
    public $processStatus;
    /**
     * The sentMessages
     * @var int
     */
    public $sentMessages;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $startDate;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The submissionId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $submissionId;
    /**
     * The totalMessages
     * @var int
     */
    public $totalMessages;
    /**
     * The waitMessages
     * @var int
     */
    public $waitMessages;
    /**
     * Constructor method for SubmissionStatus2
     * @uses SubmissionStatus2::setCanceledMessages()
     * @uses SubmissionStatus2::setEndDate()
     * @uses SubmissionStatus2::setFailedMessages()
     * @uses SubmissionStatus2::setMessageType()
     * @uses SubmissionStatus2::setNotifWaitMessages()
     * @uses SubmissionStatus2::setProcessStatus()
     * @uses SubmissionStatus2::setSentMessages()
     * @uses SubmissionStatus2::setStartDate()
     * @uses SubmissionStatus2::setStatus()
     * @uses SubmissionStatus2::setSubmissionId()
     * @uses SubmissionStatus2::setTotalMessages()
     * @uses SubmissionStatus2::setWaitMessages()
     * @param int $canceledMessages
     * @param string $endDate
     * @param int $failedMessages
     * @param int $messageType
     * @param int $notifWaitMessages
     * @param int $processStatus
     * @param int $sentMessages
     * @param string $startDate
     * @param int $status
     * @param string $submissionId
     * @param int $totalMessages
     * @param int $waitMessages
     */
    public function __construct($canceledMessages = null, $endDate = null, $failedMessages = null, $messageType = null, $notifWaitMessages = null, $processStatus = null, $sentMessages = null, $startDate = null, $status = null, $submissionId = null, $totalMessages = null, $waitMessages = null)
    {
        $this
            ->setCanceledMessages($canceledMessages)
            ->setEndDate($endDate)
            ->setFailedMessages($failedMessages)
            ->setMessageType($messageType)
            ->setNotifWaitMessages($notifWaitMessages)
            ->setProcessStatus($processStatus)
            ->setSentMessages($sentMessages)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setSubmissionId($submissionId)
            ->setTotalMessages($totalMessages)
            ->setWaitMessages($waitMessages);
    }
    /**
     * Get canceledMessages value
     * @return int|null
     */
    public function getCanceledMessages()
    {
        return $this->canceledMessages;
    }
    /**
     * Set canceledMessages value
     * @param int $canceledMessages
     * @return \StructType\SubmissionStatus2
     */
    public function setCanceledMessages($canceledMessages = null)
    {
        // validation for constraint: int
        if (!is_null($canceledMessages) && !(is_int($canceledMessages) || ctype_digit($canceledMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($canceledMessages, true), gettype($canceledMessages)), __LINE__);
        }
        $this->canceledMessages = $canceledMessages;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\SubmissionStatus2
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get failedMessages value
     * @return int|null
     */
    public function getFailedMessages()
    {
        return $this->failedMessages;
    }
    /**
     * Set failedMessages value
     * @param int $failedMessages
     * @return \StructType\SubmissionStatus2
     */
    public function setFailedMessages($failedMessages = null)
    {
        // validation for constraint: int
        if (!is_null($failedMessages) && !(is_int($failedMessages) || ctype_digit($failedMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedMessages, true), gettype($failedMessages)), __LINE__);
        }
        $this->failedMessages = $failedMessages;
        return $this;
    }
    /**
     * Get messageType value
     * @return int|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param int $messageType
     * @return \StructType\SubmissionStatus2
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: int
        if (!is_null($messageType) && !(is_int($messageType) || ctype_digit($messageType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageType, true), gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get notifWaitMessages value
     * @return int|null
     */
    public function getNotifWaitMessages()
    {
        return $this->notifWaitMessages;
    }
    /**
     * Set notifWaitMessages value
     * @param int $notifWaitMessages
     * @return \StructType\SubmissionStatus2
     */
    public function setNotifWaitMessages($notifWaitMessages = null)
    {
        // validation for constraint: int
        if (!is_null($notifWaitMessages) && !(is_int($notifWaitMessages) || ctype_digit($notifWaitMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($notifWaitMessages, true), gettype($notifWaitMessages)), __LINE__);
        }
        $this->notifWaitMessages = $notifWaitMessages;
        return $this;
    }
    /**
     * Get processStatus value
     * @return int|null
     */
    public function getProcessStatus()
    {
        return $this->processStatus;
    }
    /**
     * Set processStatus value
     * @param int $processStatus
     * @return \StructType\SubmissionStatus2
     */
    public function setProcessStatus($processStatus = null)
    {
        // validation for constraint: int
        if (!is_null($processStatus) && !(is_int($processStatus) || ctype_digit($processStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processStatus, true), gettype($processStatus)), __LINE__);
        }
        $this->processStatus = $processStatus;
        return $this;
    }
    /**
     * Get sentMessages value
     * @return int|null
     */
    public function getSentMessages()
    {
        return $this->sentMessages;
    }
    /**
     * Set sentMessages value
     * @param int $sentMessages
     * @return \StructType\SubmissionStatus2
     */
    public function setSentMessages($sentMessages = null)
    {
        // validation for constraint: int
        if (!is_null($sentMessages) && !(is_int($sentMessages) || ctype_digit($sentMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sentMessages, true), gettype($sentMessages)), __LINE__);
        }
        $this->sentMessages = $sentMessages;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\SubmissionStatus2
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\SubmissionStatus2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get submissionId value
     * @return string|null
     */
    public function getSubmissionId()
    {
        return $this->submissionId;
    }
    /**
     * Set submissionId value
     * @param string $submissionId
     * @return \StructType\SubmissionStatus2
     */
    public function setSubmissionId($submissionId = null)
    {
        // validation for constraint: string
        if (!is_null($submissionId) && !is_string($submissionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submissionId, true), gettype($submissionId)), __LINE__);
        }
        $this->submissionId = $submissionId;
        return $this;
    }
    /**
     * Get totalMessages value
     * @return int|null
     */
    public function getTotalMessages()
    {
        return $this->totalMessages;
    }
    /**
     * Set totalMessages value
     * @param int $totalMessages
     * @return \StructType\SubmissionStatus2
     */
    public function setTotalMessages($totalMessages = null)
    {
        // validation for constraint: int
        if (!is_null($totalMessages) && !(is_int($totalMessages) || ctype_digit($totalMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalMessages, true), gettype($totalMessages)), __LINE__);
        }
        $this->totalMessages = $totalMessages;
        return $this;
    }
    /**
     * Get waitMessages value
     * @return int|null
     */
    public function getWaitMessages()
    {
        return $this->waitMessages;
    }
    /**
     * Set waitMessages value
     * @param int $waitMessages
     * @return \StructType\SubmissionStatus2
     */
    public function setWaitMessages($waitMessages = null)
    {
        // validation for constraint: int
        if (!is_null($waitMessages) && !(is_int($waitMessages) || ctype_digit($waitMessages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitMessages, true), gettype($waitMessages)), __LINE__);
        }
        $this->waitMessages = $waitMessages;
        return $this;
    }
}
