<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationInfo StructType
 * @subpackage Structs
 */
class AuthenticationInfo extends AbstractStructBase
{
    /**
     * The application
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $application;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * Constructor method for AuthenticationInfo
     * @uses AuthenticationInfo::setApplication()
     * @uses AuthenticationInfo::setPassword()
     * @uses AuthenticationInfo::setUsername()
     * @param string $application
     * @param string $password
     * @param string $username
     */
    public function __construct($application = null, $password = null, $username = null)
    {
        $this
            ->setApplication($application)
            ->setPassword($password)
            ->setUsername($username);
    }
    /**
     * Get application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->application;
    }
    /**
     * Set application value
     * @param string $application
     * @return \StructType\AuthenticationInfo
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        $this->application = $application;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\AuthenticationInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\AuthenticationInfo
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
}
