<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getSmsPullSubmissionResponses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticationInfo $authentication
     * @param string $submissionId
     * @return \ArrayType\ArrayOfSmsPullSubmissionResponse|bool
     */
    public function getSmsPullSubmissionResponses(\StructType\AuthenticationInfo $authentication, $submissionId)
    {
        try {
            $this->setResult($this->getSoapClient()->getSmsPullSubmissionResponses($authentication, $submissionId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubmissionDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticationInfo $authentication
     * @param string $submissionId
     * @param string $getRecipientsStatus
     * @return \StructType\SubmissionDetails|bool
     */
    public function getSubmissionDetails(\StructType\AuthenticationInfo $authentication, $submissionId, $getRecipientsStatus)
    {
        try {
            $this->setResult($this->getSoapClient()->getSubmissionDetails($authentication, $submissionId, $getRecipientsStatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubmissionStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticationInfo $authentication
     * @param string $submissionId
     * @return \StructType\SubmissionStatus2|bool
     */
    public function getSubmissionStatus(\StructType\AuthenticationInfo $authentication, $submissionId)
    {
        try {
            $this->setResult($this->getSoapClient()->getSubmissionStatus($authentication, $submissionId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ArrayType\ArrayOfSmsPullSubmissionResponse|\StructType\SubmissionDetails|\StructType\SubmissionStatus2
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
