<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOf_xsd_substitution ArrayType
 * @subpackage Arrays
 */
class ArrayOf_xsd_substitution extends AbstractStructArrayBase
{
    /**
     * The substitution
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $substitution;
    /**
     * Constructor method for ArrayOf_xsd_substitution
     * @uses ArrayOf_xsd_substitution::setSubstitution()
     * @param string[] $substitution
     */
    public function __construct(array $substitution = array())
    {
        $this
            ->setSubstitution($substitution);
    }
    /**
     * Get substitution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSubstitution()
    {
        return isset($this->substitution) ? $this->substitution : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubstitution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubstitution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubstitutionForArrayConstraintsFromSetSubstitution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOf_xsd_substitutionSubstitutionItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOf_xsd_substitutionSubstitutionItem)) {
                $invalidValues[] = is_object($arrayOf_xsd_substitutionSubstitutionItem) ? get_class($arrayOf_xsd_substitutionSubstitutionItem) : sprintf('%s(%s)', gettype($arrayOf_xsd_substitutionSubstitutionItem), var_export($arrayOf_xsd_substitutionSubstitutionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The substitution property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set substitution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $substitution
     * @return \ArrayType\ArrayOf_xsd_substitution
     */
    public function setSubstitution(array $substitution = array())
    {
        // validation for constraint: array
        if ('' !== ($substitutionArrayErrorMessage = self::validateSubstitutionForArrayConstraintsFromSetSubstitution($substitution))) {
            throw new \InvalidArgumentException($substitutionArrayErrorMessage, __LINE__);
        }
        if (is_null($substitution) || (is_array($substitution) && empty($substitution))) {
            unset($this->substitution);
        } else {
            $this->substitution = $substitution;
        }
        return $this;
    }
    /**
     * Add item to substitution value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOf_xsd_substitution
     */
    public function addToSubstitution($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The substitution property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->substitution[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string substitution
     */
    public function getAttributeName()
    {
        return 'substitution';
    }
}
