<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://smsexpress.cloud.altice-empresas.pt/smsexpress-wsdl/SubmissionManager2.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://smsexpress.cloud.altice-empresas.pt/smsexpress-wsdl/SubmissionManager2.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelSubmission operation/method
 */
if ($cancel->cancelSubmission(new \StructType\AuthenticationInfo(), $submissionId) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getSmsPullSubmissionResponses operation/method
 */
if ($get->getSmsPullSubmissionResponses(new \StructType\AuthenticationInfo(), $submissionId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSubmissionDetails operation/method
 */
if ($get->getSubmissionDetails(new \StructType\AuthenticationInfo(), $submissionId, $getRecipientsStatus) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSubmissionStatus operation/method
 */
if ($get->getSubmissionStatus(new \StructType\AuthenticationInfo(), $submissionId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendMmsSubmission operation/method
 */
if ($send->sendMmsSubmission(new \StructType\AuthenticationInfo(), new \StructType\MmsSubmission()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendSmsPullSubmission operation/method
 */
if ($send->sendSmsPullSubmission(new \StructType\AuthenticationInfo(), new \StructType\SmsPullSubmission()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendSmsSubmission operation/method
 */
if ($send->sendSmsSubmission(new \StructType\AuthenticationInfo(), new \StructType\SmsSubmission()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendWapPushSubmission operation/method
 */
if ($send->sendWapPushSubmission(new \StructType\AuthenticationInfo(), new \StructType\WapPushSubmission()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
