<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WapPushSubmission StructType
 * @subpackage Structs
 */
class WapPushSubmission extends Submission
{
    /**
     * The link
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $link;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $message;
    /**
     * Constructor method for WapPushSubmission
     * @uses WapPushSubmission::setLink()
     * @uses WapPushSubmission::setMessage()
     * @param string $link
     * @param string $message
     */
    public function __construct($link = null, $message = null)
    {
        $this
            ->setLink($link)
            ->setMessage($message);
    }
    /**
     * Get link value
     * @return string|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param string $link
     * @return \StructType\WapPushSubmission
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($link, true), gettype($link)), __LINE__);
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\WapPushSubmission
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
