<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submission StructType
 * @subpackage Structs
 */
abstract class Submission extends AbstractStructBase
{
    /**
     * The contactLists
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOf_xsd_ContactLists
     */
    public $contactLists;
    /**
     * The deliveryDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deliveryDate;
    /**
     * The notification
     * @var bool
     */
    public $notification;
    /**
     * The notificationRecipient
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $notificationRecipient;
    /**
     * The notificationType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $notificationType;
    /**
     * The recipients
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOf_xsd_Recipients
     */
    public $recipients;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sender;
    /**
     * The validity
     * @var int
     */
    public $validity;
    /**
     * The userDataHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userDataHeader;
    /**
     * Constructor method for Submission
     * @uses Submission::setContactLists()
     * @uses Submission::setDeliveryDate()
     * @uses Submission::setNotification()
     * @uses Submission::setNotificationRecipient()
     * @uses Submission::setNotificationType()
     * @uses Submission::setRecipients()
     * @uses Submission::setSender()
     * @uses Submission::setValidity()
     * @uses Submission::setUserDataHeader()
     * @param \ArrayType\ArrayOf_xsd_ContactLists $contactLists
     * @param string $deliveryDate
     * @param bool $notification
     * @param string $notificationRecipient
     * @param string $notificationType
     * @param \ArrayType\ArrayOf_xsd_Recipients $recipients
     * @param string $sender
     * @param int $validity
     * @param string $userDataHeader
     */
    public function __construct(\ArrayType\ArrayOf_xsd_ContactLists $contactLists = null, $deliveryDate = null, $notification = null, $notificationRecipient = null, $notificationType = null, \ArrayType\ArrayOf_xsd_Recipients $recipients = null, $sender = null, $validity = null, $userDataHeader = null)
    {
        $this
            ->setContactLists($contactLists)
            ->setDeliveryDate($deliveryDate)
            ->setNotification($notification)
            ->setNotificationRecipient($notificationRecipient)
            ->setNotificationType($notificationType)
            ->setRecipients($recipients)
            ->setSender($sender)
            ->setValidity($validity)
            ->setUserDataHeader($userDataHeader);
    }
    /**
     * Get contactLists value
     * @return \ArrayType\ArrayOf_xsd_ContactLists|null
     */
    public function getContactLists()
    {
        return $this->contactLists;
    }
    /**
     * Set contactLists value
     * @param \ArrayType\ArrayOf_xsd_ContactLists $contactLists
     * @return \StructType\Submission
     */
    public function setContactLists(\ArrayType\ArrayOf_xsd_ContactLists $contactLists = null)
    {
        $this->contactLists = $contactLists;
        return $this;
    }
    /**
     * Get deliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->deliveryDate;
    }
    /**
     * Set deliveryDate value
     * @param string $deliveryDate
     * @return \StructType\Submission
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->deliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get notification value
     * @return bool|null
     */
    public function getNotification()
    {
        return $this->notification;
    }
    /**
     * Set notification value
     * @param bool $notification
     * @return \StructType\Submission
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: boolean
        if (!is_null($notification) && !is_bool($notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notification, true), gettype($notification)), __LINE__);
        }
        $this->notification = $notification;
        return $this;
    }
    /**
     * Get notificationRecipient value
     * @return string|null
     */
    public function getNotificationRecipient()
    {
        return $this->notificationRecipient;
    }
    /**
     * Set notificationRecipient value
     * @param string $notificationRecipient
     * @return \StructType\Submission
     */
    public function setNotificationRecipient($notificationRecipient = null)
    {
        // validation for constraint: string
        if (!is_null($notificationRecipient) && !is_string($notificationRecipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationRecipient, true), gettype($notificationRecipient)), __LINE__);
        }
        $this->notificationRecipient = $notificationRecipient;
        return $this;
    }
    /**
     * Get notificationType value
     * @return string|null
     */
    public function getNotificationType()
    {
        return $this->notificationType;
    }
    /**
     * Set notificationType value
     * @param string $notificationType
     * @return \StructType\Submission
     */
    public function setNotificationType($notificationType = null)
    {
        // validation for constraint: string
        if (!is_null($notificationType) && !is_string($notificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationType, true), gettype($notificationType)), __LINE__);
        }
        $this->notificationType = $notificationType;
        return $this;
    }
    /**
     * Get recipients value
     * @return \ArrayType\ArrayOf_xsd_Recipients|null
     */
    public function getRecipients()
    {
        return $this->recipients;
    }
    /**
     * Set recipients value
     * @param \ArrayType\ArrayOf_xsd_Recipients $recipients
     * @return \StructType\Submission
     */
    public function setRecipients(\ArrayType\ArrayOf_xsd_Recipients $recipients = null)
    {
        $this->recipients = $recipients;
        return $this;
    }
    /**
     * Get sender value
     * @return string|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param string $sender
     * @return \StructType\Submission
     */
    public function setSender($sender = null)
    {
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender, true), gettype($sender)), __LINE__);
        }
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get validity value
     * @return int|null
     */
    public function getValidity()
    {
        return $this->validity;
    }
    /**
     * Set validity value
     * @param int $validity
     * @return \StructType\Submission
     */
    public function setValidity($validity = null)
    {
        // validation for constraint: int
        if (!is_null($validity) && !(is_int($validity) || ctype_digit($validity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($validity, true), gettype($validity)), __LINE__);
        }
        $this->validity = $validity;
        return $this;
    }
    /**
     * Get userDataHeader value
     * @return string|null
     */
    public function getUserDataHeader()
    {
        return $this->userDataHeader;
    }
    /**
     * Set userDataHeader value
     * @param string $userDataHeader
     * @return \StructType\Submission
     */
    public function setUserDataHeader($userDataHeader = null)
    {
        // validation for constraint: string
        if (!is_null($userDataHeader) && !is_string($userDataHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userDataHeader, true), gettype($userDataHeader)), __LINE__);
        }
        $this->userDataHeader = $userDataHeader;
        return $this;
    }
}
