<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsPullSubmissionResponse StructType
 * @subpackage Structs
 */
class SmsPullSubmissionResponse extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $message;
    /**
     * The nonAddressee
     * @var bool
     */
    public $nonAddressee;
    /**
     * The originator
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $originator;
    /**
     * Constructor method for SmsPullSubmissionResponse
     * @uses SmsPullSubmissionResponse::setDate()
     * @uses SmsPullSubmissionResponse::setMessage()
     * @uses SmsPullSubmissionResponse::setNonAddressee()
     * @uses SmsPullSubmissionResponse::setOriginator()
     * @param string $date
     * @param string $message
     * @param bool $nonAddressee
     * @param string $originator
     */
    public function __construct($date = null, $message = null, $nonAddressee = null, $originator = null)
    {
        $this
            ->setDate($date)
            ->setMessage($message)
            ->setNonAddressee($nonAddressee)
            ->setOriginator($originator);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\SmsPullSubmissionResponse
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\SmsPullSubmissionResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get nonAddressee value
     * @return bool|null
     */
    public function getNonAddressee()
    {
        return $this->nonAddressee;
    }
    /**
     * Set nonAddressee value
     * @param bool $nonAddressee
     * @return \StructType\SmsPullSubmissionResponse
     */
    public function setNonAddressee($nonAddressee = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonAddressee) && !is_bool($nonAddressee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonAddressee, true), gettype($nonAddressee)), __LINE__);
        }
        $this->nonAddressee = $nonAddressee;
        return $this;
    }
    /**
     * Get originator value
     * @return string|null
     */
    public function getOriginator()
    {
        return $this->originator;
    }
    /**
     * Set originator value
     * @param string $originator
     * @return \StructType\SmsPullSubmissionResponse
     */
    public function setOriginator($originator = null)
    {
        // validation for constraint: string
        if (!is_null($originator) && !is_string($originator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originator, true), gettype($originator)), __LINE__);
        }
        $this->originator = $originator;
        return $this;
    }
}
