<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MmsSubmission StructType
 * @subpackage Structs
 */
class MmsSubmission extends Submission
{
    /**
     * The contentItems
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfContentItem
     */
    public $contentItems;
    /**
     * The messageClass
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $messageClass;
    /**
     * The smil
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $smil;
    /**
     * The subject
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $subject;
    /**
     * Constructor method for MmsSubmission
     * @uses MmsSubmission::setContentItems()
     * @uses MmsSubmission::setMessageClass()
     * @uses MmsSubmission::setSmil()
     * @uses MmsSubmission::setSubject()
     * @param \ArrayType\ArrayOfContentItem $contentItems
     * @param string $messageClass
     * @param string $smil
     * @param string $subject
     */
    public function __construct(\ArrayType\ArrayOfContentItem $contentItems = null, $messageClass = null, $smil = null, $subject = null)
    {
        $this
            ->setContentItems($contentItems)
            ->setMessageClass($messageClass)
            ->setSmil($smil)
            ->setSubject($subject);
    }
    /**
     * Get contentItems value
     * @return \ArrayType\ArrayOfContentItem|null
     */
    public function getContentItems()
    {
        return $this->contentItems;
    }
    /**
     * Set contentItems value
     * @param \ArrayType\ArrayOfContentItem $contentItems
     * @return \StructType\MmsSubmission
     */
    public function setContentItems(\ArrayType\ArrayOfContentItem $contentItems = null)
    {
        $this->contentItems = $contentItems;
        return $this;
    }
    /**
     * Get messageClass value
     * @return string|null
     */
    public function getMessageClass()
    {
        return $this->messageClass;
    }
    /**
     * Set messageClass value
     * @param string $messageClass
     * @return \StructType\MmsSubmission
     */
    public function setMessageClass($messageClass = null)
    {
        // validation for constraint: string
        if (!is_null($messageClass) && !is_string($messageClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageClass, true), gettype($messageClass)), __LINE__);
        }
        $this->messageClass = $messageClass;
        return $this;
    }
    /**
     * Get smil value
     * @return string|null
     */
    public function getSmil()
    {
        return $this->smil;
    }
    /**
     * Set smil value
     * @param string $smil
     * @return \StructType\MmsSubmission
     */
    public function setSmil($smil = null)
    {
        // validation for constraint: string
        if (!is_null($smil) && !is_string($smil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smil, true), gettype($smil)), __LINE__);
        }
        $this->smil = $smil;
        return $this;
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \StructType\MmsSubmission
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
}
