<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOf_xsd_sent ArrayType
 * @subpackage Arrays
 */
class ArrayOf_xsd_sent extends AbstractStructArrayBase
{
    /**
     * The sent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $sent;
    /**
     * Constructor method for ArrayOf_xsd_sent
     * @uses ArrayOf_xsd_sent::setSent()
     * @param string[] $sent
     */
    public function __construct(array $sent = array())
    {
        $this
            ->setSent($sent);
    }
    /**
     * Get sent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSent()
    {
        return isset($this->sent) ? $this->sent : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSentForArrayConstraintsFromSetSent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOf_xsd_sentSentItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOf_xsd_sentSentItem)) {
                $invalidValues[] = is_object($arrayOf_xsd_sentSentItem) ? get_class($arrayOf_xsd_sentSentItem) : sprintf('%s(%s)', gettype($arrayOf_xsd_sentSentItem), var_export($arrayOf_xsd_sentSentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sent property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $sent
     * @return \ArrayType\ArrayOf_xsd_sent
     */
    public function setSent(array $sent = array())
    {
        // validation for constraint: array
        if ('' !== ($sentArrayErrorMessage = self::validateSentForArrayConstraintsFromSetSent($sent))) {
            throw new \InvalidArgumentException($sentArrayErrorMessage, __LINE__);
        }
        if (is_null($sent) || (is_array($sent) && empty($sent))) {
            unset($this->sent);
        } else {
            $this->sent = $sent;
        }
        return $this;
    }
    /**
     * Add item to sent value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOf_xsd_sent
     */
    public function addToSent($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The sent property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sent[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string sent
     */
    public function getAttributeName()
    {
        return 'sent';
    }
}
