<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSmsPullSubmissionResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfSmsPullSubmissionResponse extends AbstractStructArrayBase
{
    /**
     * The xsps
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SmsPullSubmissionResponse[]
     */
    public $xsps;
    /**
     * Constructor method for ArrayOfSmsPullSubmissionResponse
     * @uses ArrayOfSmsPullSubmissionResponse::setXsps()
     * @param \StructType\SmsPullSubmissionResponse[] $xsps
     */
    public function __construct(array $xsps = array())
    {
        $this
            ->setXsps($xsps);
    }
    /**
     * Get xsps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SmsPullSubmissionResponse[]|null
     */
    public function getXsps()
    {
        return isset($this->xsps) ? $this->xsps : null;
    }
    /**
     * This method is responsible for validating the values passed to the setXsps method
     * This method is willingly generated in order to preserve the one-line inline validation within the setXsps method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateXspsForArrayConstraintsFromSetXsps(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSmsPullSubmissionResponseXspsItem) {
            // validation for constraint: itemType
            if (!$arrayOfSmsPullSubmissionResponseXspsItem instanceof \StructType\SmsPullSubmissionResponse) {
                $invalidValues[] = is_object($arrayOfSmsPullSubmissionResponseXspsItem) ? get_class($arrayOfSmsPullSubmissionResponseXspsItem) : sprintf('%s(%s)', gettype($arrayOfSmsPullSubmissionResponseXspsItem), var_export($arrayOfSmsPullSubmissionResponseXspsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The xsps property can only contain items of type \StructType\SmsPullSubmissionResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set xsps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SmsPullSubmissionResponse[] $xsps
     * @return \ArrayType\ArrayOfSmsPullSubmissionResponse
     */
    public function setXsps(array $xsps = array())
    {
        // validation for constraint: array
        if ('' !== ($xspsArrayErrorMessage = self::validateXspsForArrayConstraintsFromSetXsps($xsps))) {
            throw new \InvalidArgumentException($xspsArrayErrorMessage, __LINE__);
        }
        if (is_null($xsps) || (is_array($xsps) && empty($xsps))) {
            unset($this->xsps);
        } else {
            $this->xsps = $xsps;
        }
        return $this;
    }
    /**
     * Add item to xsps value
     * @throws \InvalidArgumentException
     * @param \StructType\SmsPullSubmissionResponse $item
     * @return \ArrayType\ArrayOfSmsPullSubmissionResponse
     */
    public function addToXsps(\StructType\SmsPullSubmissionResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SmsPullSubmissionResponse) {
            throw new \InvalidArgumentException(sprintf('The xsps property can only contain items of type \StructType\SmsPullSubmissionResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->xsps[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SmsPullSubmissionResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SmsPullSubmissionResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SmsPullSubmissionResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SmsPullSubmissionResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SmsPullSubmissionResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string xsps
     */
    public function getAttributeName()
    {
        return 'xsps';
    }
}
