<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KSube StructType
 * @subpackage Structs
 */
class KSube extends Entity
{
    /**
     * The Tipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tipi;
    /**
     * The GunlukCalismaDurum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GunlukCalismaDurum;
    /**
     * The TipTur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TipTur;
    /**
     * The AktarmayaUzaklik
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AktarmayaUzaklik;
    /**
     * The SP_IsyeriObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_IsyeriObjId;
    /**
     * The IsTahsilatKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTahsilatKapali;
    /**
     * The IsFaturaKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFaturaKapali;
    /**
     * The IsTesellumKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTesellumKapali;
    /**
     * The IsTeslimatKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTeslimatKapali;
    /**
     * The IsYuklemeKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsYuklemeKapali;
    /**
     * The IsMusteriSozlesmeKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMusteriSozlesmeKapali;
    /**
     * The IsAracSozlesmeKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAracSozlesmeKapali;
    /**
     * The IsCariKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCariKapali;
    /**
     * The Faaliyettemi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Faaliyettemi;
    /**
     * The IsMerkezSITesellumKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMerkezSITesellumKapali;
    /**
     * The IsBolgeSITesellumKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBolgeSITesellumKapali;
    /**
     * The GazeteBayiKDVOran
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GazeteBayiKDVOran;
    /**
     * The IsKibris
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKibris;
    /**
     * The IslemTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IslemTarihi;
    /**
     * The KapatilmaTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KapatilmaTarihi;
    /**
     * The FaaliyetDurdurulmaTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FaaliyetDurdurulmaTarihi;
    /**
     * The IsSaatKontrolAcik
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSaatKontrolAcik;
    /**
     * The UpdateEdilecekAlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UpdateEdilecekAlan;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The BagliOlduguSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSubePointer
     */
    public $BagliOlduguSube;
    /**
     * The BagliOlduguAktarma
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSubePointer
     */
    public $BagliOlduguAktarma;
    /**
     * The Carisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KCariPointer
     */
    public $Carisi;
    /**
     * The Adresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAdresPointer
     */
    public $Adresi;
    /**
     * The IPTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IPTel;
    /**
     * The SabitTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SabitTel;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Gsm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gsm;
    /**
     * The GsmKisa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GsmKisa;
    /**
     * The Enlem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Enlem;
    /**
     * The Boylam
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Boylam;
    /**
     * The ReferansGrup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferansGrup;
    /**
     * The NobetBitSaati
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NobetBitSaati;
    /**
     * The EvrakKesimBasSaati
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBasSaati;
    /**
     * The EvrakKesimBasSaatiDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBasSaatiDefault;
    /**
     * The EvrakKesimBitSaati
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBitSaati;
    /**
     * The EvrakKesimBitSaatiDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBitSaatiDefault;
    /**
     * The EvrakKesimBasSaatiCts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBasSaatiCts;
    /**
     * The EvrakKesimBasSaatiCtsDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBasSaatiCtsDefault;
    /**
     * The EvrakKesimBitSaatiCts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBitSaatiCts;
    /**
     * The EvrakKesimBitSaatiCtsDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBitSaatiCtsDefault;
    /**
     * The EvrakKesimBasSaatiPzr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBasSaatiPzr;
    /**
     * The EvrakKesimBasSaatiPzrDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBasSaatiPzrDefault;
    /**
     * The EvrakKesimBitSaatiPzr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBitSaatiPzr;
    /**
     * The EvrakKesimBitSaatiPzrDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBitSaatiPzrDefault;
    /**
     * The KSubeBiyografileri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKSubeBiyografisi
     */
    public $KSubeBiyografileri;
    /**
     * The GrupNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GrupNo;
    /**
     * The MikroKontrol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MikroKontrol;
    /**
     * The SubeTipleri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubeTipleri;
    /**
     * Constructor method for KSube
     * @uses KSube::setTipi()
     * @uses KSube::setGunlukCalismaDurum()
     * @uses KSube::setTipTur()
     * @uses KSube::setAktarmayaUzaklik()
     * @uses KSube::setSP_IsyeriObjId()
     * @uses KSube::setIsTahsilatKapali()
     * @uses KSube::setIsFaturaKapali()
     * @uses KSube::setIsTesellumKapali()
     * @uses KSube::setIsTeslimatKapali()
     * @uses KSube::setIsYuklemeKapali()
     * @uses KSube::setIsMusteriSozlesmeKapali()
     * @uses KSube::setIsAracSozlesmeKapali()
     * @uses KSube::setIsCariKapali()
     * @uses KSube::setFaaliyettemi()
     * @uses KSube::setIsMerkezSITesellumKapali()
     * @uses KSube::setIsBolgeSITesellumKapali()
     * @uses KSube::setGazeteBayiKDVOran()
     * @uses KSube::setIsKibris()
     * @uses KSube::setIslemTarihi()
     * @uses KSube::setKapatilmaTarihi()
     * @uses KSube::setFaaliyetDurdurulmaTarihi()
     * @uses KSube::setIsSaatKontrolAcik()
     * @uses KSube::setUpdateEdilecekAlan()
     * @uses KSube::setAdi()
     * @uses KSube::setKodu()
     * @uses KSube::setAciklama()
     * @uses KSube::setBagliOlduguSube()
     * @uses KSube::setBagliOlduguAktarma()
     * @uses KSube::setCarisi()
     * @uses KSube::setAdresi()
     * @uses KSube::setIPTel()
     * @uses KSube::setSabitTel()
     * @uses KSube::setFax()
     * @uses KSube::setGsm()
     * @uses KSube::setGsmKisa()
     * @uses KSube::setEnlem()
     * @uses KSube::setBoylam()
     * @uses KSube::setReferansGrup()
     * @uses KSube::setNobetBitSaati()
     * @uses KSube::setEvrakKesimBasSaati()
     * @uses KSube::setEvrakKesimBasSaatiDefault()
     * @uses KSube::setEvrakKesimBitSaati()
     * @uses KSube::setEvrakKesimBitSaatiDefault()
     * @uses KSube::setEvrakKesimBasSaatiCts()
     * @uses KSube::setEvrakKesimBasSaatiCtsDefault()
     * @uses KSube::setEvrakKesimBitSaatiCts()
     * @uses KSube::setEvrakKesimBitSaatiCtsDefault()
     * @uses KSube::setEvrakKesimBasSaatiPzr()
     * @uses KSube::setEvrakKesimBasSaatiPzrDefault()
     * @uses KSube::setEvrakKesimBitSaatiPzr()
     * @uses KSube::setEvrakKesimBitSaatiPzrDefault()
     * @uses KSube::setKSubeBiyografileri()
     * @uses KSube::setGrupNo()
     * @uses KSube::setMikroKontrol()
     * @uses KSube::setSubeTipleri()
     * @param string $tipi
     * @param string $gunlukCalismaDurum
     * @param string $tipTur
     * @param float $aktarmayaUzaklik
     * @param int $sP_IsyeriObjId
     * @param bool $isTahsilatKapali
     * @param bool $isFaturaKapali
     * @param bool $isTesellumKapali
     * @param bool $isTeslimatKapali
     * @param bool $isYuklemeKapali
     * @param bool $isMusteriSozlesmeKapali
     * @param bool $isAracSozlesmeKapali
     * @param bool $isCariKapali
     * @param bool $faaliyettemi
     * @param bool $isMerkezSITesellumKapali
     * @param bool $isBolgeSITesellumKapali
     * @param float $gazeteBayiKDVOran
     * @param bool $isKibris
     * @param string $islemTarihi
     * @param string $kapatilmaTarihi
     * @param string $faaliyetDurdurulmaTarihi
     * @param bool $isSaatKontrolAcik
     * @param string $updateEdilecekAlan
     * @param string $adi
     * @param string $kodu
     * @param string $aciklama
     * @param \StructType\KSubePointer $bagliOlduguSube
     * @param \StructType\KSubePointer $bagliOlduguAktarma
     * @param \StructType\KCariPointer $carisi
     * @param \StructType\KAdresPointer $adresi
     * @param string $iPTel
     * @param string $sabitTel
     * @param string $fax
     * @param string $gsm
     * @param string $gsmKisa
     * @param string $enlem
     * @param string $boylam
     * @param string $referansGrup
     * @param string $nobetBitSaati
     * @param string $evrakKesimBasSaati
     * @param string $evrakKesimBasSaatiDefault
     * @param string $evrakKesimBitSaati
     * @param string $evrakKesimBitSaatiDefault
     * @param string $evrakKesimBasSaatiCts
     * @param string $evrakKesimBasSaatiCtsDefault
     * @param string $evrakKesimBitSaatiCts
     * @param string $evrakKesimBitSaatiCtsDefault
     * @param string $evrakKesimBasSaatiPzr
     * @param string $evrakKesimBasSaatiPzrDefault
     * @param string $evrakKesimBitSaatiPzr
     * @param string $evrakKesimBitSaatiPzrDefault
     * @param \ArrayType\ArrayOfKSubeBiyografisi $kSubeBiyografileri
     * @param string $grupNo
     * @param string $mikroKontrol
     * @param string $subeTipleri
     */
    public function __construct($tipi = null, $gunlukCalismaDurum = null, $tipTur = null, $aktarmayaUzaklik = null, $sP_IsyeriObjId = null, $isTahsilatKapali = null, $isFaturaKapali = null, $isTesellumKapali = null, $isTeslimatKapali = null, $isYuklemeKapali = null, $isMusteriSozlesmeKapali = null, $isAracSozlesmeKapali = null, $isCariKapali = null, $faaliyettemi = null, $isMerkezSITesellumKapali = null, $isBolgeSITesellumKapali = null, $gazeteBayiKDVOran = null, $isKibris = null, $islemTarihi = null, $kapatilmaTarihi = null, $faaliyetDurdurulmaTarihi = null, $isSaatKontrolAcik = null, $updateEdilecekAlan = null, $adi = null, $kodu = null, $aciklama = null, \StructType\KSubePointer $bagliOlduguSube = null, \StructType\KSubePointer $bagliOlduguAktarma = null, \StructType\KCariPointer $carisi = null, \StructType\KAdresPointer $adresi = null, $iPTel = null, $sabitTel = null, $fax = null, $gsm = null, $gsmKisa = null, $enlem = null, $boylam = null, $referansGrup = null, $nobetBitSaati = null, $evrakKesimBasSaati = null, $evrakKesimBasSaatiDefault = null, $evrakKesimBitSaati = null, $evrakKesimBitSaatiDefault = null, $evrakKesimBasSaatiCts = null, $evrakKesimBasSaatiCtsDefault = null, $evrakKesimBitSaatiCts = null, $evrakKesimBitSaatiCtsDefault = null, $evrakKesimBasSaatiPzr = null, $evrakKesimBasSaatiPzrDefault = null, $evrakKesimBitSaatiPzr = null, $evrakKesimBitSaatiPzrDefault = null, \ArrayType\ArrayOfKSubeBiyografisi $kSubeBiyografileri = null, $grupNo = null, $mikroKontrol = null, $subeTipleri = null)
    {
        $this
            ->setTipi($tipi)
            ->setGunlukCalismaDurum($gunlukCalismaDurum)
            ->setTipTur($tipTur)
            ->setAktarmayaUzaklik($aktarmayaUzaklik)
            ->setSP_IsyeriObjId($sP_IsyeriObjId)
            ->setIsTahsilatKapali($isTahsilatKapali)
            ->setIsFaturaKapali($isFaturaKapali)
            ->setIsTesellumKapali($isTesellumKapali)
            ->setIsTeslimatKapali($isTeslimatKapali)
            ->setIsYuklemeKapali($isYuklemeKapali)
            ->setIsMusteriSozlesmeKapali($isMusteriSozlesmeKapali)
            ->setIsAracSozlesmeKapali($isAracSozlesmeKapali)
            ->setIsCariKapali($isCariKapali)
            ->setFaaliyettemi($faaliyettemi)
            ->setIsMerkezSITesellumKapali($isMerkezSITesellumKapali)
            ->setIsBolgeSITesellumKapali($isBolgeSITesellumKapali)
            ->setGazeteBayiKDVOran($gazeteBayiKDVOran)
            ->setIsKibris($isKibris)
            ->setIslemTarihi($islemTarihi)
            ->setKapatilmaTarihi($kapatilmaTarihi)
            ->setFaaliyetDurdurulmaTarihi($faaliyetDurdurulmaTarihi)
            ->setIsSaatKontrolAcik($isSaatKontrolAcik)
            ->setUpdateEdilecekAlan($updateEdilecekAlan)
            ->setAdi($adi)
            ->setKodu($kodu)
            ->setAciklama($aciklama)
            ->setBagliOlduguSube($bagliOlduguSube)
            ->setBagliOlduguAktarma($bagliOlduguAktarma)
            ->setCarisi($carisi)
            ->setAdresi($adresi)
            ->setIPTel($iPTel)
            ->setSabitTel($sabitTel)
            ->setFax($fax)
            ->setGsm($gsm)
            ->setGsmKisa($gsmKisa)
            ->setEnlem($enlem)
            ->setBoylam($boylam)
            ->setReferansGrup($referansGrup)
            ->setNobetBitSaati($nobetBitSaati)
            ->setEvrakKesimBasSaati($evrakKesimBasSaati)
            ->setEvrakKesimBasSaatiDefault($evrakKesimBasSaatiDefault)
            ->setEvrakKesimBitSaati($evrakKesimBitSaati)
            ->setEvrakKesimBitSaatiDefault($evrakKesimBitSaatiDefault)
            ->setEvrakKesimBasSaatiCts($evrakKesimBasSaatiCts)
            ->setEvrakKesimBasSaatiCtsDefault($evrakKesimBasSaatiCtsDefault)
            ->setEvrakKesimBitSaatiCts($evrakKesimBitSaatiCts)
            ->setEvrakKesimBitSaatiCtsDefault($evrakKesimBitSaatiCtsDefault)
            ->setEvrakKesimBasSaatiPzr($evrakKesimBasSaatiPzr)
            ->setEvrakKesimBasSaatiPzrDefault($evrakKesimBasSaatiPzrDefault)
            ->setEvrakKesimBitSaatiPzr($evrakKesimBitSaatiPzr)
            ->setEvrakKesimBitSaatiPzrDefault($evrakKesimBitSaatiPzrDefault)
            ->setKSubeBiyografileri($kSubeBiyografileri)
            ->setGrupNo($grupNo)
            ->setMikroKontrol($mikroKontrol)
            ->setSubeTipleri($subeTipleri);
    }
    /**
     * Get Tipi value
     * @return string
     */
    public function getTipi()
    {
        return $this->Tipi;
    }
    /**
     * Set Tipi value
     * @uses \EnumType\SubeTip::valueIsValid()
     * @uses \EnumType\SubeTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipi
     * @return \StructType\KSube
     */
    public function setTipi($tipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SubeTip::valueIsValid($tipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SubeTip', is_array($tipi) ? implode(', ', $tipi) : var_export($tipi, true), implode(', ', \EnumType\SubeTip::getValidValues())), __LINE__);
        }
        $this->Tipi = $tipi;
        return $this;
    }
    /**
     * Get GunlukCalismaDurum value
     * @return string
     */
    public function getGunlukCalismaDurum()
    {
        return $this->GunlukCalismaDurum;
    }
    /**
     * Set GunlukCalismaDurum value
     * @uses \EnumType\GunlukCalismaDurum::valueIsValid()
     * @uses \EnumType\GunlukCalismaDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gunlukCalismaDurum
     * @return \StructType\KSube
     */
    public function setGunlukCalismaDurum($gunlukCalismaDurum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GunlukCalismaDurum::valueIsValid($gunlukCalismaDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GunlukCalismaDurum', is_array($gunlukCalismaDurum) ? implode(', ', $gunlukCalismaDurum) : var_export($gunlukCalismaDurum, true), implode(', ', \EnumType\GunlukCalismaDurum::getValidValues())), __LINE__);
        }
        $this->GunlukCalismaDurum = $gunlukCalismaDurum;
        return $this;
    }
    /**
     * Get TipTur value
     * @return string
     */
    public function getTipTur()
    {
        return $this->TipTur;
    }
    /**
     * Set TipTur value
     * @uses \EnumType\SubeTipTur::valueIsValid()
     * @uses \EnumType\SubeTipTur::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipTur
     * @return \StructType\KSube
     */
    public function setTipTur($tipTur = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SubeTipTur::valueIsValid($tipTur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SubeTipTur', is_array($tipTur) ? implode(', ', $tipTur) : var_export($tipTur, true), implode(', ', \EnumType\SubeTipTur::getValidValues())), __LINE__);
        }
        $this->TipTur = $tipTur;
        return $this;
    }
    /**
     * Get AktarmayaUzaklik value
     * @return float
     */
    public function getAktarmayaUzaklik()
    {
        return $this->AktarmayaUzaklik;
    }
    /**
     * Set AktarmayaUzaklik value
     * @param float $aktarmayaUzaklik
     * @return \StructType\KSube
     */
    public function setAktarmayaUzaklik($aktarmayaUzaklik = null)
    {
        // validation for constraint: float
        if (!is_null($aktarmayaUzaklik) && !(is_float($aktarmayaUzaklik) || is_numeric($aktarmayaUzaklik))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aktarmayaUzaklik, true), gettype($aktarmayaUzaklik)), __LINE__);
        }
        $this->AktarmayaUzaklik = $aktarmayaUzaklik;
        return $this;
    }
    /**
     * Get SP_IsyeriObjId value
     * @return int
     */
    public function getSP_IsyeriObjId()
    {
        return $this->SP_IsyeriObjId;
    }
    /**
     * Set SP_IsyeriObjId value
     * @param int $sP_IsyeriObjId
     * @return \StructType\KSube
     */
    public function setSP_IsyeriObjId($sP_IsyeriObjId = null)
    {
        // validation for constraint: int
        if (!is_null($sP_IsyeriObjId) && !(is_int($sP_IsyeriObjId) || ctype_digit($sP_IsyeriObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_IsyeriObjId, true), gettype($sP_IsyeriObjId)), __LINE__);
        }
        $this->SP_IsyeriObjId = $sP_IsyeriObjId;
        return $this;
    }
    /**
     * Get IsTahsilatKapali value
     * @return bool
     */
    public function getIsTahsilatKapali()
    {
        return $this->IsTahsilatKapali;
    }
    /**
     * Set IsTahsilatKapali value
     * @param bool $isTahsilatKapali
     * @return \StructType\KSube
     */
    public function setIsTahsilatKapali($isTahsilatKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTahsilatKapali) && !is_bool($isTahsilatKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTahsilatKapali, true), gettype($isTahsilatKapali)), __LINE__);
        }
        $this->IsTahsilatKapali = $isTahsilatKapali;
        return $this;
    }
    /**
     * Get IsFaturaKapali value
     * @return bool
     */
    public function getIsFaturaKapali()
    {
        return $this->IsFaturaKapali;
    }
    /**
     * Set IsFaturaKapali value
     * @param bool $isFaturaKapali
     * @return \StructType\KSube
     */
    public function setIsFaturaKapali($isFaturaKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFaturaKapali) && !is_bool($isFaturaKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFaturaKapali, true), gettype($isFaturaKapali)), __LINE__);
        }
        $this->IsFaturaKapali = $isFaturaKapali;
        return $this;
    }
    /**
     * Get IsTesellumKapali value
     * @return bool
     */
    public function getIsTesellumKapali()
    {
        return $this->IsTesellumKapali;
    }
    /**
     * Set IsTesellumKapali value
     * @param bool $isTesellumKapali
     * @return \StructType\KSube
     */
    public function setIsTesellumKapali($isTesellumKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTesellumKapali) && !is_bool($isTesellumKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTesellumKapali, true), gettype($isTesellumKapali)), __LINE__);
        }
        $this->IsTesellumKapali = $isTesellumKapali;
        return $this;
    }
    /**
     * Get IsTeslimatKapali value
     * @return bool
     */
    public function getIsTeslimatKapali()
    {
        return $this->IsTeslimatKapali;
    }
    /**
     * Set IsTeslimatKapali value
     * @param bool $isTeslimatKapali
     * @return \StructType\KSube
     */
    public function setIsTeslimatKapali($isTeslimatKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTeslimatKapali) && !is_bool($isTeslimatKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTeslimatKapali, true), gettype($isTeslimatKapali)), __LINE__);
        }
        $this->IsTeslimatKapali = $isTeslimatKapali;
        return $this;
    }
    /**
     * Get IsYuklemeKapali value
     * @return bool
     */
    public function getIsYuklemeKapali()
    {
        return $this->IsYuklemeKapali;
    }
    /**
     * Set IsYuklemeKapali value
     * @param bool $isYuklemeKapali
     * @return \StructType\KSube
     */
    public function setIsYuklemeKapali($isYuklemeKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isYuklemeKapali) && !is_bool($isYuklemeKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isYuklemeKapali, true), gettype($isYuklemeKapali)), __LINE__);
        }
        $this->IsYuklemeKapali = $isYuklemeKapali;
        return $this;
    }
    /**
     * Get IsMusteriSozlesmeKapali value
     * @return bool
     */
    public function getIsMusteriSozlesmeKapali()
    {
        return $this->IsMusteriSozlesmeKapali;
    }
    /**
     * Set IsMusteriSozlesmeKapali value
     * @param bool $isMusteriSozlesmeKapali
     * @return \StructType\KSube
     */
    public function setIsMusteriSozlesmeKapali($isMusteriSozlesmeKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMusteriSozlesmeKapali) && !is_bool($isMusteriSozlesmeKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMusteriSozlesmeKapali, true), gettype($isMusteriSozlesmeKapali)), __LINE__);
        }
        $this->IsMusteriSozlesmeKapali = $isMusteriSozlesmeKapali;
        return $this;
    }
    /**
     * Get IsAracSozlesmeKapali value
     * @return bool
     */
    public function getIsAracSozlesmeKapali()
    {
        return $this->IsAracSozlesmeKapali;
    }
    /**
     * Set IsAracSozlesmeKapali value
     * @param bool $isAracSozlesmeKapali
     * @return \StructType\KSube
     */
    public function setIsAracSozlesmeKapali($isAracSozlesmeKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAracSozlesmeKapali) && !is_bool($isAracSozlesmeKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAracSozlesmeKapali, true), gettype($isAracSozlesmeKapali)), __LINE__);
        }
        $this->IsAracSozlesmeKapali = $isAracSozlesmeKapali;
        return $this;
    }
    /**
     * Get IsCariKapali value
     * @return bool
     */
    public function getIsCariKapali()
    {
        return $this->IsCariKapali;
    }
    /**
     * Set IsCariKapali value
     * @param bool $isCariKapali
     * @return \StructType\KSube
     */
    public function setIsCariKapali($isCariKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCariKapali) && !is_bool($isCariKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCariKapali, true), gettype($isCariKapali)), __LINE__);
        }
        $this->IsCariKapali = $isCariKapali;
        return $this;
    }
    /**
     * Get Faaliyettemi value
     * @return bool
     */
    public function getFaaliyettemi()
    {
        return $this->Faaliyettemi;
    }
    /**
     * Set Faaliyettemi value
     * @param bool $faaliyettemi
     * @return \StructType\KSube
     */
    public function setFaaliyettemi($faaliyettemi = null)
    {
        // validation for constraint: boolean
        if (!is_null($faaliyettemi) && !is_bool($faaliyettemi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($faaliyettemi, true), gettype($faaliyettemi)), __LINE__);
        }
        $this->Faaliyettemi = $faaliyettemi;
        return $this;
    }
    /**
     * Get IsMerkezSITesellumKapali value
     * @return bool
     */
    public function getIsMerkezSITesellumKapali()
    {
        return $this->IsMerkezSITesellumKapali;
    }
    /**
     * Set IsMerkezSITesellumKapali value
     * @param bool $isMerkezSITesellumKapali
     * @return \StructType\KSube
     */
    public function setIsMerkezSITesellumKapali($isMerkezSITesellumKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMerkezSITesellumKapali) && !is_bool($isMerkezSITesellumKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMerkezSITesellumKapali, true), gettype($isMerkezSITesellumKapali)), __LINE__);
        }
        $this->IsMerkezSITesellumKapali = $isMerkezSITesellumKapali;
        return $this;
    }
    /**
     * Get IsBolgeSITesellumKapali value
     * @return bool
     */
    public function getIsBolgeSITesellumKapali()
    {
        return $this->IsBolgeSITesellumKapali;
    }
    /**
     * Set IsBolgeSITesellumKapali value
     * @param bool $isBolgeSITesellumKapali
     * @return \StructType\KSube
     */
    public function setIsBolgeSITesellumKapali($isBolgeSITesellumKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBolgeSITesellumKapali) && !is_bool($isBolgeSITesellumKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBolgeSITesellumKapali, true), gettype($isBolgeSITesellumKapali)), __LINE__);
        }
        $this->IsBolgeSITesellumKapali = $isBolgeSITesellumKapali;
        return $this;
    }
    /**
     * Get GazeteBayiKDVOran value
     * @return float
     */
    public function getGazeteBayiKDVOran()
    {
        return $this->GazeteBayiKDVOran;
    }
    /**
     * Set GazeteBayiKDVOran value
     * @param float $gazeteBayiKDVOran
     * @return \StructType\KSube
     */
    public function setGazeteBayiKDVOran($gazeteBayiKDVOran = null)
    {
        // validation for constraint: float
        if (!is_null($gazeteBayiKDVOran) && !(is_float($gazeteBayiKDVOran) || is_numeric($gazeteBayiKDVOran))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gazeteBayiKDVOran, true), gettype($gazeteBayiKDVOran)), __LINE__);
        }
        $this->GazeteBayiKDVOran = $gazeteBayiKDVOran;
        return $this;
    }
    /**
     * Get IsKibris value
     * @return bool
     */
    public function getIsKibris()
    {
        return $this->IsKibris;
    }
    /**
     * Set IsKibris value
     * @param bool $isKibris
     * @return \StructType\KSube
     */
    public function setIsKibris($isKibris = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKibris) && !is_bool($isKibris)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKibris, true), gettype($isKibris)), __LINE__);
        }
        $this->IsKibris = $isKibris;
        return $this;
    }
    /**
     * Get IslemTarihi value
     * @return string
     */
    public function getIslemTarihi()
    {
        return $this->IslemTarihi;
    }
    /**
     * Set IslemTarihi value
     * @param string $islemTarihi
     * @return \StructType\KSube
     */
    public function setIslemTarihi($islemTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($islemTarihi) && !is_string($islemTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($islemTarihi, true), gettype($islemTarihi)), __LINE__);
        }
        $this->IslemTarihi = $islemTarihi;
        return $this;
    }
    /**
     * Get KapatilmaTarihi value
     * @return string
     */
    public function getKapatilmaTarihi()
    {
        return $this->KapatilmaTarihi;
    }
    /**
     * Set KapatilmaTarihi value
     * @param string $kapatilmaTarihi
     * @return \StructType\KSube
     */
    public function setKapatilmaTarihi($kapatilmaTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($kapatilmaTarihi) && !is_string($kapatilmaTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kapatilmaTarihi, true), gettype($kapatilmaTarihi)), __LINE__);
        }
        $this->KapatilmaTarihi = $kapatilmaTarihi;
        return $this;
    }
    /**
     * Get FaaliyetDurdurulmaTarihi value
     * @return string
     */
    public function getFaaliyetDurdurulmaTarihi()
    {
        return $this->FaaliyetDurdurulmaTarihi;
    }
    /**
     * Set FaaliyetDurdurulmaTarihi value
     * @param string $faaliyetDurdurulmaTarihi
     * @return \StructType\KSube
     */
    public function setFaaliyetDurdurulmaTarihi($faaliyetDurdurulmaTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($faaliyetDurdurulmaTarihi) && !is_string($faaliyetDurdurulmaTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faaliyetDurdurulmaTarihi, true), gettype($faaliyetDurdurulmaTarihi)), __LINE__);
        }
        $this->FaaliyetDurdurulmaTarihi = $faaliyetDurdurulmaTarihi;
        return $this;
    }
    /**
     * Get IsSaatKontrolAcik value
     * @return bool
     */
    public function getIsSaatKontrolAcik()
    {
        return $this->IsSaatKontrolAcik;
    }
    /**
     * Set IsSaatKontrolAcik value
     * @param bool $isSaatKontrolAcik
     * @return \StructType\KSube
     */
    public function setIsSaatKontrolAcik($isSaatKontrolAcik = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSaatKontrolAcik) && !is_bool($isSaatKontrolAcik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSaatKontrolAcik, true), gettype($isSaatKontrolAcik)), __LINE__);
        }
        $this->IsSaatKontrolAcik = $isSaatKontrolAcik;
        return $this;
    }
    /**
     * Get UpdateEdilecekAlan value
     * @return string
     */
    public function getUpdateEdilecekAlan()
    {
        return $this->UpdateEdilecekAlan;
    }
    /**
     * Set UpdateEdilecekAlan value
     * @uses \EnumType\UpdateEdilecekAlan::valueIsValid()
     * @uses \EnumType\UpdateEdilecekAlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $updateEdilecekAlan
     * @return \StructType\KSube
     */
    public function setUpdateEdilecekAlan($updateEdilecekAlan = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UpdateEdilecekAlan::valueIsValid($updateEdilecekAlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UpdateEdilecekAlan', is_array($updateEdilecekAlan) ? implode(', ', $updateEdilecekAlan) : var_export($updateEdilecekAlan, true), implode(', ', \EnumType\UpdateEdilecekAlan::getValidValues())), __LINE__);
        }
        $this->UpdateEdilecekAlan = $updateEdilecekAlan;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \StructType\KSube
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \StructType\KSube
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\KSube
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get BagliOlduguSube value
     * @return \StructType\KSubePointer|null
     */
    public function getBagliOlduguSube()
    {
        return $this->BagliOlduguSube;
    }
    /**
     * Set BagliOlduguSube value
     * @param \StructType\KSubePointer $bagliOlduguSube
     * @return \StructType\KSube
     */
    public function setBagliOlduguSube(\StructType\KSubePointer $bagliOlduguSube = null)
    {
        $this->BagliOlduguSube = $bagliOlduguSube;
        return $this;
    }
    /**
     * Get BagliOlduguAktarma value
     * @return \StructType\KSubePointer|null
     */
    public function getBagliOlduguAktarma()
    {
        return $this->BagliOlduguAktarma;
    }
    /**
     * Set BagliOlduguAktarma value
     * @param \StructType\KSubePointer $bagliOlduguAktarma
     * @return \StructType\KSube
     */
    public function setBagliOlduguAktarma(\StructType\KSubePointer $bagliOlduguAktarma = null)
    {
        $this->BagliOlduguAktarma = $bagliOlduguAktarma;
        return $this;
    }
    /**
     * Get Carisi value
     * @return \StructType\KCariPointer|null
     */
    public function getCarisi()
    {
        return $this->Carisi;
    }
    /**
     * Set Carisi value
     * @param \StructType\KCariPointer $carisi
     * @return \StructType\KSube
     */
    public function setCarisi(\StructType\KCariPointer $carisi = null)
    {
        $this->Carisi = $carisi;
        return $this;
    }
    /**
     * Get Adresi value
     * @return \StructType\KAdresPointer|null
     */
    public function getAdresi()
    {
        return $this->Adresi;
    }
    /**
     * Set Adresi value
     * @param \StructType\KAdresPointer $adresi
     * @return \StructType\KSube
     */
    public function setAdresi(\StructType\KAdresPointer $adresi = null)
    {
        $this->Adresi = $adresi;
        return $this;
    }
    /**
     * Get IPTel value
     * @return string|null
     */
    public function getIPTel()
    {
        return $this->IPTel;
    }
    /**
     * Set IPTel value
     * @param string $iPTel
     * @return \StructType\KSube
     */
    public function setIPTel($iPTel = null)
    {
        // validation for constraint: string
        if (!is_null($iPTel) && !is_string($iPTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iPTel, true), gettype($iPTel)), __LINE__);
        }
        $this->IPTel = $iPTel;
        return $this;
    }
    /**
     * Get SabitTel value
     * @return string|null
     */
    public function getSabitTel()
    {
        return $this->SabitTel;
    }
    /**
     * Set SabitTel value
     * @param string $sabitTel
     * @return \StructType\KSube
     */
    public function setSabitTel($sabitTel = null)
    {
        // validation for constraint: string
        if (!is_null($sabitTel) && !is_string($sabitTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sabitTel, true), gettype($sabitTel)), __LINE__);
        }
        $this->SabitTel = $sabitTel;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\KSube
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Gsm value
     * @return string|null
     */
    public function getGsm()
    {
        return $this->Gsm;
    }
    /**
     * Set Gsm value
     * @param string $gsm
     * @return \StructType\KSube
     */
    public function setGsm($gsm = null)
    {
        // validation for constraint: string
        if (!is_null($gsm) && !is_string($gsm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsm, true), gettype($gsm)), __LINE__);
        }
        $this->Gsm = $gsm;
        return $this;
    }
    /**
     * Get GsmKisa value
     * @return string|null
     */
    public function getGsmKisa()
    {
        return $this->GsmKisa;
    }
    /**
     * Set GsmKisa value
     * @param string $gsmKisa
     * @return \StructType\KSube
     */
    public function setGsmKisa($gsmKisa = null)
    {
        // validation for constraint: string
        if (!is_null($gsmKisa) && !is_string($gsmKisa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsmKisa, true), gettype($gsmKisa)), __LINE__);
        }
        $this->GsmKisa = $gsmKisa;
        return $this;
    }
    /**
     * Get Enlem value
     * @return string|null
     */
    public function getEnlem()
    {
        return $this->Enlem;
    }
    /**
     * Set Enlem value
     * @param string $enlem
     * @return \StructType\KSube
     */
    public function setEnlem($enlem = null)
    {
        // validation for constraint: string
        if (!is_null($enlem) && !is_string($enlem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enlem, true), gettype($enlem)), __LINE__);
        }
        $this->Enlem = $enlem;
        return $this;
    }
    /**
     * Get Boylam value
     * @return string|null
     */
    public function getBoylam()
    {
        return $this->Boylam;
    }
    /**
     * Set Boylam value
     * @param string $boylam
     * @return \StructType\KSube
     */
    public function setBoylam($boylam = null)
    {
        // validation for constraint: string
        if (!is_null($boylam) && !is_string($boylam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boylam, true), gettype($boylam)), __LINE__);
        }
        $this->Boylam = $boylam;
        return $this;
    }
    /**
     * Get ReferansGrup value
     * @return string|null
     */
    public function getReferansGrup()
    {
        return $this->ReferansGrup;
    }
    /**
     * Set ReferansGrup value
     * @param string $referansGrup
     * @return \StructType\KSube
     */
    public function setReferansGrup($referansGrup = null)
    {
        // validation for constraint: string
        if (!is_null($referansGrup) && !is_string($referansGrup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referansGrup, true), gettype($referansGrup)), __LINE__);
        }
        $this->ReferansGrup = $referansGrup;
        return $this;
    }
    /**
     * Get NobetBitSaati value
     * @return string|null
     */
    public function getNobetBitSaati()
    {
        return $this->NobetBitSaati;
    }
    /**
     * Set NobetBitSaati value
     * @param string $nobetBitSaati
     * @return \StructType\KSube
     */
    public function setNobetBitSaati($nobetBitSaati = null)
    {
        // validation for constraint: string
        if (!is_null($nobetBitSaati) && !is_string($nobetBitSaati)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nobetBitSaati, true), gettype($nobetBitSaati)), __LINE__);
        }
        $this->NobetBitSaati = $nobetBitSaati;
        return $this;
    }
    /**
     * Get EvrakKesimBasSaati value
     * @return string|null
     */
    public function getEvrakKesimBasSaati()
    {
        return $this->EvrakKesimBasSaati;
    }
    /**
     * Set EvrakKesimBasSaati value
     * @param string $evrakKesimBasSaati
     * @return \StructType\KSube
     */
    public function setEvrakKesimBasSaati($evrakKesimBasSaati = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBasSaati) && !is_string($evrakKesimBasSaati)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBasSaati, true), gettype($evrakKesimBasSaati)), __LINE__);
        }
        $this->EvrakKesimBasSaati = $evrakKesimBasSaati;
        return $this;
    }
    /**
     * Get EvrakKesimBasSaatiDefault value
     * @return string|null
     */
    public function getEvrakKesimBasSaatiDefault()
    {
        return $this->EvrakKesimBasSaatiDefault;
    }
    /**
     * Set EvrakKesimBasSaatiDefault value
     * @param string $evrakKesimBasSaatiDefault
     * @return \StructType\KSube
     */
    public function setEvrakKesimBasSaatiDefault($evrakKesimBasSaatiDefault = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBasSaatiDefault) && !is_string($evrakKesimBasSaatiDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBasSaatiDefault, true), gettype($evrakKesimBasSaatiDefault)), __LINE__);
        }
        $this->EvrakKesimBasSaatiDefault = $evrakKesimBasSaatiDefault;
        return $this;
    }
    /**
     * Get EvrakKesimBitSaati value
     * @return string|null
     */
    public function getEvrakKesimBitSaati()
    {
        return $this->EvrakKesimBitSaati;
    }
    /**
     * Set EvrakKesimBitSaati value
     * @param string $evrakKesimBitSaati
     * @return \StructType\KSube
     */
    public function setEvrakKesimBitSaati($evrakKesimBitSaati = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBitSaati) && !is_string($evrakKesimBitSaati)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBitSaati, true), gettype($evrakKesimBitSaati)), __LINE__);
        }
        $this->EvrakKesimBitSaati = $evrakKesimBitSaati;
        return $this;
    }
    /**
     * Get EvrakKesimBitSaatiDefault value
     * @return string|null
     */
    public function getEvrakKesimBitSaatiDefault()
    {
        return $this->EvrakKesimBitSaatiDefault;
    }
    /**
     * Set EvrakKesimBitSaatiDefault value
     * @param string $evrakKesimBitSaatiDefault
     * @return \StructType\KSube
     */
    public function setEvrakKesimBitSaatiDefault($evrakKesimBitSaatiDefault = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBitSaatiDefault) && !is_string($evrakKesimBitSaatiDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBitSaatiDefault, true), gettype($evrakKesimBitSaatiDefault)), __LINE__);
        }
        $this->EvrakKesimBitSaatiDefault = $evrakKesimBitSaatiDefault;
        return $this;
    }
    /**
     * Get EvrakKesimBasSaatiCts value
     * @return string|null
     */
    public function getEvrakKesimBasSaatiCts()
    {
        return $this->EvrakKesimBasSaatiCts;
    }
    /**
     * Set EvrakKesimBasSaatiCts value
     * @param string $evrakKesimBasSaatiCts
     * @return \StructType\KSube
     */
    public function setEvrakKesimBasSaatiCts($evrakKesimBasSaatiCts = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBasSaatiCts) && !is_string($evrakKesimBasSaatiCts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBasSaatiCts, true), gettype($evrakKesimBasSaatiCts)), __LINE__);
        }
        $this->EvrakKesimBasSaatiCts = $evrakKesimBasSaatiCts;
        return $this;
    }
    /**
     * Get EvrakKesimBasSaatiCtsDefault value
     * @return string|null
     */
    public function getEvrakKesimBasSaatiCtsDefault()
    {
        return $this->EvrakKesimBasSaatiCtsDefault;
    }
    /**
     * Set EvrakKesimBasSaatiCtsDefault value
     * @param string $evrakKesimBasSaatiCtsDefault
     * @return \StructType\KSube
     */
    public function setEvrakKesimBasSaatiCtsDefault($evrakKesimBasSaatiCtsDefault = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBasSaatiCtsDefault) && !is_string($evrakKesimBasSaatiCtsDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBasSaatiCtsDefault, true), gettype($evrakKesimBasSaatiCtsDefault)), __LINE__);
        }
        $this->EvrakKesimBasSaatiCtsDefault = $evrakKesimBasSaatiCtsDefault;
        return $this;
    }
    /**
     * Get EvrakKesimBitSaatiCts value
     * @return string|null
     */
    public function getEvrakKesimBitSaatiCts()
    {
        return $this->EvrakKesimBitSaatiCts;
    }
    /**
     * Set EvrakKesimBitSaatiCts value
     * @param string $evrakKesimBitSaatiCts
     * @return \StructType\KSube
     */
    public function setEvrakKesimBitSaatiCts($evrakKesimBitSaatiCts = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBitSaatiCts) && !is_string($evrakKesimBitSaatiCts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBitSaatiCts, true), gettype($evrakKesimBitSaatiCts)), __LINE__);
        }
        $this->EvrakKesimBitSaatiCts = $evrakKesimBitSaatiCts;
        return $this;
    }
    /**
     * Get EvrakKesimBitSaatiCtsDefault value
     * @return string|null
     */
    public function getEvrakKesimBitSaatiCtsDefault()
    {
        return $this->EvrakKesimBitSaatiCtsDefault;
    }
    /**
     * Set EvrakKesimBitSaatiCtsDefault value
     * @param string $evrakKesimBitSaatiCtsDefault
     * @return \StructType\KSube
     */
    public function setEvrakKesimBitSaatiCtsDefault($evrakKesimBitSaatiCtsDefault = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBitSaatiCtsDefault) && !is_string($evrakKesimBitSaatiCtsDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBitSaatiCtsDefault, true), gettype($evrakKesimBitSaatiCtsDefault)), __LINE__);
        }
        $this->EvrakKesimBitSaatiCtsDefault = $evrakKesimBitSaatiCtsDefault;
        return $this;
    }
    /**
     * Get EvrakKesimBasSaatiPzr value
     * @return string|null
     */
    public function getEvrakKesimBasSaatiPzr()
    {
        return $this->EvrakKesimBasSaatiPzr;
    }
    /**
     * Set EvrakKesimBasSaatiPzr value
     * @param string $evrakKesimBasSaatiPzr
     * @return \StructType\KSube
     */
    public function setEvrakKesimBasSaatiPzr($evrakKesimBasSaatiPzr = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBasSaatiPzr) && !is_string($evrakKesimBasSaatiPzr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBasSaatiPzr, true), gettype($evrakKesimBasSaatiPzr)), __LINE__);
        }
        $this->EvrakKesimBasSaatiPzr = $evrakKesimBasSaatiPzr;
        return $this;
    }
    /**
     * Get EvrakKesimBasSaatiPzrDefault value
     * @return string|null
     */
    public function getEvrakKesimBasSaatiPzrDefault()
    {
        return $this->EvrakKesimBasSaatiPzrDefault;
    }
    /**
     * Set EvrakKesimBasSaatiPzrDefault value
     * @param string $evrakKesimBasSaatiPzrDefault
     * @return \StructType\KSube
     */
    public function setEvrakKesimBasSaatiPzrDefault($evrakKesimBasSaatiPzrDefault = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBasSaatiPzrDefault) && !is_string($evrakKesimBasSaatiPzrDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBasSaatiPzrDefault, true), gettype($evrakKesimBasSaatiPzrDefault)), __LINE__);
        }
        $this->EvrakKesimBasSaatiPzrDefault = $evrakKesimBasSaatiPzrDefault;
        return $this;
    }
    /**
     * Get EvrakKesimBitSaatiPzr value
     * @return string|null
     */
    public function getEvrakKesimBitSaatiPzr()
    {
        return $this->EvrakKesimBitSaatiPzr;
    }
    /**
     * Set EvrakKesimBitSaatiPzr value
     * @param string $evrakKesimBitSaatiPzr
     * @return \StructType\KSube
     */
    public function setEvrakKesimBitSaatiPzr($evrakKesimBitSaatiPzr = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBitSaatiPzr) && !is_string($evrakKesimBitSaatiPzr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBitSaatiPzr, true), gettype($evrakKesimBitSaatiPzr)), __LINE__);
        }
        $this->EvrakKesimBitSaatiPzr = $evrakKesimBitSaatiPzr;
        return $this;
    }
    /**
     * Get EvrakKesimBitSaatiPzrDefault value
     * @return string|null
     */
    public function getEvrakKesimBitSaatiPzrDefault()
    {
        return $this->EvrakKesimBitSaatiPzrDefault;
    }
    /**
     * Set EvrakKesimBitSaatiPzrDefault value
     * @param string $evrakKesimBitSaatiPzrDefault
     * @return \StructType\KSube
     */
    public function setEvrakKesimBitSaatiPzrDefault($evrakKesimBitSaatiPzrDefault = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBitSaatiPzrDefault) && !is_string($evrakKesimBitSaatiPzrDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBitSaatiPzrDefault, true), gettype($evrakKesimBitSaatiPzrDefault)), __LINE__);
        }
        $this->EvrakKesimBitSaatiPzrDefault = $evrakKesimBitSaatiPzrDefault;
        return $this;
    }
    /**
     * Get KSubeBiyografileri value
     * @return \ArrayType\ArrayOfKSubeBiyografisi|null
     */
    public function getKSubeBiyografileri()
    {
        return $this->KSubeBiyografileri;
    }
    /**
     * Set KSubeBiyografileri value
     * @param \ArrayType\ArrayOfKSubeBiyografisi $kSubeBiyografileri
     * @return \StructType\KSube
     */
    public function setKSubeBiyografileri(\ArrayType\ArrayOfKSubeBiyografisi $kSubeBiyografileri = null)
    {
        $this->KSubeBiyografileri = $kSubeBiyografileri;
        return $this;
    }
    /**
     * Get GrupNo value
     * @return string|null
     */
    public function getGrupNo()
    {
        return $this->GrupNo;
    }
    /**
     * Set GrupNo value
     * @param string $grupNo
     * @return \StructType\KSube
     */
    public function setGrupNo($grupNo = null)
    {
        // validation for constraint: string
        if (!is_null($grupNo) && !is_string($grupNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupNo, true), gettype($grupNo)), __LINE__);
        }
        $this->GrupNo = $grupNo;
        return $this;
    }
    /**
     * Get MikroKontrol value
     * @return string|null
     */
    public function getMikroKontrol()
    {
        return $this->MikroKontrol;
    }
    /**
     * Set MikroKontrol value
     * @param string $mikroKontrol
     * @return \StructType\KSube
     */
    public function setMikroKontrol($mikroKontrol = null)
    {
        // validation for constraint: string
        if (!is_null($mikroKontrol) && !is_string($mikroKontrol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mikroKontrol, true), gettype($mikroKontrol)), __LINE__);
        }
        $this->MikroKontrol = $mikroKontrol;
        return $this;
    }
    /**
     * Get SubeTipleri value
     * @return string|null
     */
    public function getSubeTipleri()
    {
        return $this->SubeTipleri;
    }
    /**
     * Set SubeTipleri value
     * @param string $subeTipleri
     * @return \StructType\KSube
     */
    public function setSubeTipleri($subeTipleri = null)
    {
        // validation for constraint: string
        if (!is_null($subeTipleri) && !is_string($subeTipleri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subeTipleri, true), gettype($subeTipleri)), __LINE__);
        }
        $this->SubeTipleri = $subeTipleri;
        return $this;
    }
}
