<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KKargoHareket StructType
 * @subpackage Structs
 */
class KKargoHareket extends Entity
{
    /**
     * The HareketTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTip;
    /**
     * The HareketTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketTar;
    /**
     * The HareketKaynak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HareketKaynak;
    /**
     * The IslemNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IslemNo;
    /**
     * The RotaNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RotaNo;
    /**
     * The Kargo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KKargoPointer
     */
    public $Kargo;
    /**
     * The AracSeferAyak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAracSeferAyakPointer
     */
    public $AracSeferAyak;
    /**
     * The Sube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KSubePointer
     */
    public $Sube;
    /**
     * The Arac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAracKaraPointer
     */
    public $Arac;
    /**
     * The AracSefer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAracSeferPointer
     */
    public $AracSefer;
    /**
     * The KargoTeslimat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KKargoTeslimatPointer
     */
    public $KargoTeslimat;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Kurye
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KPersonelPointer
     */
    public $Kurye;
    /**
     * Constructor method for KKargoHareket
     * @uses KKargoHareket::setHareketTip()
     * @uses KKargoHareket::setHareketTar()
     * @uses KKargoHareket::setHareketKaynak()
     * @uses KKargoHareket::setIslemNo()
     * @uses KKargoHareket::setRotaNo()
     * @uses KKargoHareket::setKargo()
     * @uses KKargoHareket::setAracSeferAyak()
     * @uses KKargoHareket::setSube()
     * @uses KKargoHareket::setArac()
     * @uses KKargoHareket::setAracSefer()
     * @uses KKargoHareket::setKargoTeslimat()
     * @uses KKargoHareket::setAciklama()
     * @uses KKargoHareket::setKurye()
     * @param string $hareketTip
     * @param string $hareketTar
     * @param string $hareketKaynak
     * @param int $islemNo
     * @param int $rotaNo
     * @param \StructType\KKargoPointer $kargo
     * @param \StructType\KAracSeferAyakPointer $aracSeferAyak
     * @param \StructType\KSubePointer $sube
     * @param \StructType\KAracKaraPointer $arac
     * @param \StructType\KAracSeferPointer $aracSefer
     * @param \StructType\KKargoTeslimatPointer $kargoTeslimat
     * @param string $aciklama
     * @param \StructType\KPersonelPointer $kurye
     */
    public function __construct($hareketTip = null, $hareketTar = null, $hareketKaynak = null, $islemNo = null, $rotaNo = null, \StructType\KKargoPointer $kargo = null, \StructType\KAracSeferAyakPointer $aracSeferAyak = null, \StructType\KSubePointer $sube = null, \StructType\KAracKaraPointer $arac = null, \StructType\KAracSeferPointer $aracSefer = null, \StructType\KKargoTeslimatPointer $kargoTeslimat = null, $aciklama = null, \StructType\KPersonelPointer $kurye = null)
    {
        $this
            ->setHareketTip($hareketTip)
            ->setHareketTar($hareketTar)
            ->setHareketKaynak($hareketKaynak)
            ->setIslemNo($islemNo)
            ->setRotaNo($rotaNo)
            ->setKargo($kargo)
            ->setAracSeferAyak($aracSeferAyak)
            ->setSube($sube)
            ->setArac($arac)
            ->setAracSefer($aracSefer)
            ->setKargoTeslimat($kargoTeslimat)
            ->setAciklama($aciklama)
            ->setKurye($kurye);
    }
    /**
     * Get HareketTip value
     * @return string
     */
    public function getHareketTip()
    {
        return $this->HareketTip;
    }
    /**
     * Set HareketTip value
     * @uses \EnumType\KargoHareketTip::valueIsValid()
     * @uses \EnumType\KargoHareketTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hareketTip
     * @return \StructType\KKargoHareket
     */
    public function setHareketTip($hareketTip = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KargoHareketTip::valueIsValid($hareketTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KargoHareketTip', is_array($hareketTip) ? implode(', ', $hareketTip) : var_export($hareketTip, true), implode(', ', \EnumType\KargoHareketTip::getValidValues())), __LINE__);
        }
        $this->HareketTip = $hareketTip;
        return $this;
    }
    /**
     * Get HareketTar value
     * @return string
     */
    public function getHareketTar()
    {
        return $this->HareketTar;
    }
    /**
     * Set HareketTar value
     * @param string $hareketTar
     * @return \StructType\KKargoHareket
     */
    public function setHareketTar($hareketTar = null)
    {
        // validation for constraint: string
        if (!is_null($hareketTar) && !is_string($hareketTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hareketTar, true), gettype($hareketTar)), __LINE__);
        }
        $this->HareketTar = $hareketTar;
        return $this;
    }
    /**
     * Get HareketKaynak value
     * @return string
     */
    public function getHareketKaynak()
    {
        return $this->HareketKaynak;
    }
    /**
     * Set HareketKaynak value
     * @uses \EnumType\KargoHareketKaynak::valueIsValid()
     * @uses \EnumType\KargoHareketKaynak::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hareketKaynak
     * @return \StructType\KKargoHareket
     */
    public function setHareketKaynak($hareketKaynak = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KargoHareketKaynak::valueIsValid($hareketKaynak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KargoHareketKaynak', is_array($hareketKaynak) ? implode(', ', $hareketKaynak) : var_export($hareketKaynak, true), implode(', ', \EnumType\KargoHareketKaynak::getValidValues())), __LINE__);
        }
        $this->HareketKaynak = $hareketKaynak;
        return $this;
    }
    /**
     * Get IslemNo value
     * @return int
     */
    public function getIslemNo()
    {
        return $this->IslemNo;
    }
    /**
     * Set IslemNo value
     * @param int $islemNo
     * @return \StructType\KKargoHareket
     */
    public function setIslemNo($islemNo = null)
    {
        // validation for constraint: int
        if (!is_null($islemNo) && !(is_int($islemNo) || ctype_digit($islemNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($islemNo, true), gettype($islemNo)), __LINE__);
        }
        $this->IslemNo = $islemNo;
        return $this;
    }
    /**
     * Get RotaNo value
     * @return int
     */
    public function getRotaNo()
    {
        return $this->RotaNo;
    }
    /**
     * Set RotaNo value
     * @param int $rotaNo
     * @return \StructType\KKargoHareket
     */
    public function setRotaNo($rotaNo = null)
    {
        // validation for constraint: int
        if (!is_null($rotaNo) && !(is_int($rotaNo) || ctype_digit($rotaNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rotaNo, true), gettype($rotaNo)), __LINE__);
        }
        $this->RotaNo = $rotaNo;
        return $this;
    }
    /**
     * Get Kargo value
     * @return \StructType\KKargoPointer|null
     */
    public function getKargo()
    {
        return $this->Kargo;
    }
    /**
     * Set Kargo value
     * @param \StructType\KKargoPointer $kargo
     * @return \StructType\KKargoHareket
     */
    public function setKargo(\StructType\KKargoPointer $kargo = null)
    {
        $this->Kargo = $kargo;
        return $this;
    }
    /**
     * Get AracSeferAyak value
     * @return \StructType\KAracSeferAyakPointer|null
     */
    public function getAracSeferAyak()
    {
        return $this->AracSeferAyak;
    }
    /**
     * Set AracSeferAyak value
     * @param \StructType\KAracSeferAyakPointer $aracSeferAyak
     * @return \StructType\KKargoHareket
     */
    public function setAracSeferAyak(\StructType\KAracSeferAyakPointer $aracSeferAyak = null)
    {
        $this->AracSeferAyak = $aracSeferAyak;
        return $this;
    }
    /**
     * Get Sube value
     * @return \StructType\KSubePointer|null
     */
    public function getSube()
    {
        return $this->Sube;
    }
    /**
     * Set Sube value
     * @param \StructType\KSubePointer $sube
     * @return \StructType\KKargoHareket
     */
    public function setSube(\StructType\KSubePointer $sube = null)
    {
        $this->Sube = $sube;
        return $this;
    }
    /**
     * Get Arac value
     * @return \StructType\KAracKaraPointer|null
     */
    public function getArac()
    {
        return $this->Arac;
    }
    /**
     * Set Arac value
     * @param \StructType\KAracKaraPointer $arac
     * @return \StructType\KKargoHareket
     */
    public function setArac(\StructType\KAracKaraPointer $arac = null)
    {
        $this->Arac = $arac;
        return $this;
    }
    /**
     * Get AracSefer value
     * @return \StructType\KAracSeferPointer|null
     */
    public function getAracSefer()
    {
        return $this->AracSefer;
    }
    /**
     * Set AracSefer value
     * @param \StructType\KAracSeferPointer $aracSefer
     * @return \StructType\KKargoHareket
     */
    public function setAracSefer(\StructType\KAracSeferPointer $aracSefer = null)
    {
        $this->AracSefer = $aracSefer;
        return $this;
    }
    /**
     * Get KargoTeslimat value
     * @return \StructType\KKargoTeslimatPointer|null
     */
    public function getKargoTeslimat()
    {
        return $this->KargoTeslimat;
    }
    /**
     * Set KargoTeslimat value
     * @param \StructType\KKargoTeslimatPointer $kargoTeslimat
     * @return \StructType\KKargoHareket
     */
    public function setKargoTeslimat(\StructType\KKargoTeslimatPointer $kargoTeslimat = null)
    {
        $this->KargoTeslimat = $kargoTeslimat;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\KKargoHareket
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Kurye value
     * @return \StructType\KPersonelPointer|null
     */
    public function getKurye()
    {
        return $this->Kurye;
    }
    /**
     * Set Kurye value
     * @param \StructType\KPersonelPointer $kurye
     * @return \StructType\KKargoHareket
     */
    public function setKurye(\StructType\KPersonelPointer $kurye = null)
    {
        $this->Kurye = $kurye;
        return $this;
    }
}
