<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KEvrakAyar StructType
 * @subpackage Structs
 */
class KEvrakAyar extends Entity
{
    /**
     * The EvrakTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EvrakTipi;
    /**
     * The IsEkhizmetVar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEkhizmetVar;
    /**
     * The FiyatHesaplamaSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FiyatHesaplamaSekli;
    /**
     * The IsKargoTasiniyor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKargoTasiniyor;
    /**
     * The CariTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CariTipi;
    /**
     * The SubeTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SubeTipi;
    /**
     * The IsAraciFirmaVar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAraciFirmaVar;
    /**
     * The EvrakTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EvrakTuru;
    /**
     * The OdemeSekliTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OdemeSekliTipi;
    /**
     * The IsKDVManual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKDVManual;
    /**
     * The IsFaturalasacak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFaturalasacak;
    /**
     * The KargoIlkDurum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KargoIlkDurum;
    /**
     * The AyarRengi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AyarRengi;
    /**
     * The IsSatisEvraki
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSatisEvraki;
    /**
     * The IsTahsilatSubesiSerbest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTahsilatSubesiSerbest;
    /**
     * The IsSonradanDegistirilebilir
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSonradanDegistirilebilir;
    /**
     * The IsHizmetSatirdanSecilecek
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsHizmetSatirdanSecilecek;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Hizmeti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KHizmetPointer
     */
    public $Hizmeti;
    /**
     * Constructor method for KEvrakAyar
     * @uses KEvrakAyar::setEvrakTipi()
     * @uses KEvrakAyar::setIsEkhizmetVar()
     * @uses KEvrakAyar::setFiyatHesaplamaSekli()
     * @uses KEvrakAyar::setIsKargoTasiniyor()
     * @uses KEvrakAyar::setCariTipi()
     * @uses KEvrakAyar::setSubeTipi()
     * @uses KEvrakAyar::setIsAraciFirmaVar()
     * @uses KEvrakAyar::setEvrakTuru()
     * @uses KEvrakAyar::setOdemeSekliTipi()
     * @uses KEvrakAyar::setIsKDVManual()
     * @uses KEvrakAyar::setIsFaturalasacak()
     * @uses KEvrakAyar::setKargoIlkDurum()
     * @uses KEvrakAyar::setAyarRengi()
     * @uses KEvrakAyar::setIsSatisEvraki()
     * @uses KEvrakAyar::setIsTahsilatSubesiSerbest()
     * @uses KEvrakAyar::setIsSonradanDegistirilebilir()
     * @uses KEvrakAyar::setIsHizmetSatirdanSecilecek()
     * @uses KEvrakAyar::setAdi()
     * @uses KEvrakAyar::setAciklama()
     * @uses KEvrakAyar::setHizmeti()
     * @param string $evrakTipi
     * @param bool $isEkhizmetVar
     * @param string $fiyatHesaplamaSekli
     * @param bool $isKargoTasiniyor
     * @param string $cariTipi
     * @param string $subeTipi
     * @param bool $isAraciFirmaVar
     * @param string $evrakTuru
     * @param string $odemeSekliTipi
     * @param bool $isKDVManual
     * @param bool $isFaturalasacak
     * @param string $kargoIlkDurum
     * @param int $ayarRengi
     * @param bool $isSatisEvraki
     * @param bool $isTahsilatSubesiSerbest
     * @param bool $isSonradanDegistirilebilir
     * @param bool $isHizmetSatirdanSecilecek
     * @param string $adi
     * @param string $aciklama
     * @param \StructType\KHizmetPointer $hizmeti
     */
    public function __construct($evrakTipi = null, $isEkhizmetVar = null, $fiyatHesaplamaSekli = null, $isKargoTasiniyor = null, $cariTipi = null, $subeTipi = null, $isAraciFirmaVar = null, $evrakTuru = null, $odemeSekliTipi = null, $isKDVManual = null, $isFaturalasacak = null, $kargoIlkDurum = null, $ayarRengi = null, $isSatisEvraki = null, $isTahsilatSubesiSerbest = null, $isSonradanDegistirilebilir = null, $isHizmetSatirdanSecilecek = null, $adi = null, $aciklama = null, \StructType\KHizmetPointer $hizmeti = null)
    {
        $this
            ->setEvrakTipi($evrakTipi)
            ->setIsEkhizmetVar($isEkhizmetVar)
            ->setFiyatHesaplamaSekli($fiyatHesaplamaSekli)
            ->setIsKargoTasiniyor($isKargoTasiniyor)
            ->setCariTipi($cariTipi)
            ->setSubeTipi($subeTipi)
            ->setIsAraciFirmaVar($isAraciFirmaVar)
            ->setEvrakTuru($evrakTuru)
            ->setOdemeSekliTipi($odemeSekliTipi)
            ->setIsKDVManual($isKDVManual)
            ->setIsFaturalasacak($isFaturalasacak)
            ->setKargoIlkDurum($kargoIlkDurum)
            ->setAyarRengi($ayarRengi)
            ->setIsSatisEvraki($isSatisEvraki)
            ->setIsTahsilatSubesiSerbest($isTahsilatSubesiSerbest)
            ->setIsSonradanDegistirilebilir($isSonradanDegistirilebilir)
            ->setIsHizmetSatirdanSecilecek($isHizmetSatirdanSecilecek)
            ->setAdi($adi)
            ->setAciklama($aciklama)
            ->setHizmeti($hizmeti);
    }
    /**
     * Get EvrakTipi value
     * @return string
     */
    public function getEvrakTipi()
    {
        return $this->EvrakTipi;
    }
    /**
     * Set EvrakTipi value
     * @uses \EnumType\FATTES::valueIsValid()
     * @uses \EnumType\FATTES::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $evrakTipi
     * @return \StructType\KEvrakAyar
     */
    public function setEvrakTipi($evrakTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FATTES::valueIsValid($evrakTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FATTES', is_array($evrakTipi) ? implode(', ', $evrakTipi) : var_export($evrakTipi, true), implode(', ', \EnumType\FATTES::getValidValues())), __LINE__);
        }
        $this->EvrakTipi = $evrakTipi;
        return $this;
    }
    /**
     * Get IsEkhizmetVar value
     * @return bool
     */
    public function getIsEkhizmetVar()
    {
        return $this->IsEkhizmetVar;
    }
    /**
     * Set IsEkhizmetVar value
     * @param bool $isEkhizmetVar
     * @return \StructType\KEvrakAyar
     */
    public function setIsEkhizmetVar($isEkhizmetVar = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEkhizmetVar) && !is_bool($isEkhizmetVar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEkhizmetVar, true), gettype($isEkhizmetVar)), __LINE__);
        }
        $this->IsEkhizmetVar = $isEkhizmetVar;
        return $this;
    }
    /**
     * Get FiyatHesaplamaSekli value
     * @return string
     */
    public function getFiyatHesaplamaSekli()
    {
        return $this->FiyatHesaplamaSekli;
    }
    /**
     * Set FiyatHesaplamaSekli value
     * @uses \EnumType\KEvrakFiyatHasaplamaSekli::valueIsValid()
     * @uses \EnumType\KEvrakFiyatHasaplamaSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fiyatHesaplamaSekli
     * @return \StructType\KEvrakAyar
     */
    public function setFiyatHesaplamaSekli($fiyatHesaplamaSekli = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KEvrakFiyatHasaplamaSekli::valueIsValid($fiyatHesaplamaSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KEvrakFiyatHasaplamaSekli', is_array($fiyatHesaplamaSekli) ? implode(', ', $fiyatHesaplamaSekli) : var_export($fiyatHesaplamaSekli, true), implode(', ', \EnumType\KEvrakFiyatHasaplamaSekli::getValidValues())), __LINE__);
        }
        $this->FiyatHesaplamaSekli = $fiyatHesaplamaSekli;
        return $this;
    }
    /**
     * Get IsKargoTasiniyor value
     * @return bool
     */
    public function getIsKargoTasiniyor()
    {
        return $this->IsKargoTasiniyor;
    }
    /**
     * Set IsKargoTasiniyor value
     * @param bool $isKargoTasiniyor
     * @return \StructType\KEvrakAyar
     */
    public function setIsKargoTasiniyor($isKargoTasiniyor = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKargoTasiniyor) && !is_bool($isKargoTasiniyor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKargoTasiniyor, true), gettype($isKargoTasiniyor)), __LINE__);
        }
        $this->IsKargoTasiniyor = $isKargoTasiniyor;
        return $this;
    }
    /**
     * Get CariTipi value
     * @return string
     */
    public function getCariTipi()
    {
        return $this->CariTipi;
    }
    /**
     * Set CariTipi value
     * @uses \EnumType\KEvrakCariTipi::valueIsValid()
     * @uses \EnumType\KEvrakCariTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cariTipi
     * @return \StructType\KEvrakAyar
     */
    public function setCariTipi($cariTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KEvrakCariTipi::valueIsValid($cariTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KEvrakCariTipi', is_array($cariTipi) ? implode(', ', $cariTipi) : var_export($cariTipi, true), implode(', ', \EnumType\KEvrakCariTipi::getValidValues())), __LINE__);
        }
        $this->CariTipi = $cariTipi;
        return $this;
    }
    /**
     * Get SubeTipi value
     * @return string
     */
    public function getSubeTipi()
    {
        return $this->SubeTipi;
    }
    /**
     * Set SubeTipi value
     * @uses \EnumType\KEvrakSubeTipi::valueIsValid()
     * @uses \EnumType\KEvrakSubeTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subeTipi
     * @return \StructType\KEvrakAyar
     */
    public function setSubeTipi($subeTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KEvrakSubeTipi::valueIsValid($subeTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KEvrakSubeTipi', is_array($subeTipi) ? implode(', ', $subeTipi) : var_export($subeTipi, true), implode(', ', \EnumType\KEvrakSubeTipi::getValidValues())), __LINE__);
        }
        $this->SubeTipi = $subeTipi;
        return $this;
    }
    /**
     * Get IsAraciFirmaVar value
     * @return bool
     */
    public function getIsAraciFirmaVar()
    {
        return $this->IsAraciFirmaVar;
    }
    /**
     * Set IsAraciFirmaVar value
     * @param bool $isAraciFirmaVar
     * @return \StructType\KEvrakAyar
     */
    public function setIsAraciFirmaVar($isAraciFirmaVar = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAraciFirmaVar) && !is_bool($isAraciFirmaVar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAraciFirmaVar, true), gettype($isAraciFirmaVar)), __LINE__);
        }
        $this->IsAraciFirmaVar = $isAraciFirmaVar;
        return $this;
    }
    /**
     * Get EvrakTuru value
     * @return string
     */
    public function getEvrakTuru()
    {
        return $this->EvrakTuru;
    }
    /**
     * Set EvrakTuru value
     * @uses \EnumType\KEvrakTurleri::valueIsValid()
     * @uses \EnumType\KEvrakTurleri::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $evrakTuru
     * @return \StructType\KEvrakAyar
     */
    public function setEvrakTuru($evrakTuru = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KEvrakTurleri::valueIsValid($evrakTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KEvrakTurleri', is_array($evrakTuru) ? implode(', ', $evrakTuru) : var_export($evrakTuru, true), implode(', ', \EnumType\KEvrakTurleri::getValidValues())), __LINE__);
        }
        $this->EvrakTuru = $evrakTuru;
        return $this;
    }
    /**
     * Get OdemeSekliTipi value
     * @return string
     */
    public function getOdemeSekliTipi()
    {
        return $this->OdemeSekliTipi;
    }
    /**
     * Set OdemeSekliTipi value
     * @uses \EnumType\KOdemSekliTipi::valueIsValid()
     * @uses \EnumType\KOdemSekliTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemeSekliTipi
     * @return \StructType\KEvrakAyar
     */
    public function setOdemeSekliTipi($odemeSekliTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KOdemSekliTipi::valueIsValid($odemeSekliTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KOdemSekliTipi', is_array($odemeSekliTipi) ? implode(', ', $odemeSekliTipi) : var_export($odemeSekliTipi, true), implode(', ', \EnumType\KOdemSekliTipi::getValidValues())), __LINE__);
        }
        $this->OdemeSekliTipi = $odemeSekliTipi;
        return $this;
    }
    /**
     * Get IsKDVManual value
     * @return bool
     */
    public function getIsKDVManual()
    {
        return $this->IsKDVManual;
    }
    /**
     * Set IsKDVManual value
     * @param bool $isKDVManual
     * @return \StructType\KEvrakAyar
     */
    public function setIsKDVManual($isKDVManual = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKDVManual) && !is_bool($isKDVManual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKDVManual, true), gettype($isKDVManual)), __LINE__);
        }
        $this->IsKDVManual = $isKDVManual;
        return $this;
    }
    /**
     * Get IsFaturalasacak value
     * @return bool
     */
    public function getIsFaturalasacak()
    {
        return $this->IsFaturalasacak;
    }
    /**
     * Set IsFaturalasacak value
     * @param bool $isFaturalasacak
     * @return \StructType\KEvrakAyar
     */
    public function setIsFaturalasacak($isFaturalasacak = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFaturalasacak) && !is_bool($isFaturalasacak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFaturalasacak, true), gettype($isFaturalasacak)), __LINE__);
        }
        $this->IsFaturalasacak = $isFaturalasacak;
        return $this;
    }
    /**
     * Get KargoIlkDurum value
     * @return string
     */
    public function getKargoIlkDurum()
    {
        return $this->KargoIlkDurum;
    }
    /**
     * Set KargoIlkDurum value
     * @uses \EnumType\KargoDurum::valueIsValid()
     * @uses \EnumType\KargoDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kargoIlkDurum
     * @return \StructType\KEvrakAyar
     */
    public function setKargoIlkDurum($kargoIlkDurum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KargoDurum::valueIsValid($kargoIlkDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KargoDurum', is_array($kargoIlkDurum) ? implode(', ', $kargoIlkDurum) : var_export($kargoIlkDurum, true), implode(', ', \EnumType\KargoDurum::getValidValues())), __LINE__);
        }
        $this->KargoIlkDurum = $kargoIlkDurum;
        return $this;
    }
    /**
     * Get AyarRengi value
     * @return int
     */
    public function getAyarRengi()
    {
        return $this->AyarRengi;
    }
    /**
     * Set AyarRengi value
     * @param int $ayarRengi
     * @return \StructType\KEvrakAyar
     */
    public function setAyarRengi($ayarRengi = null)
    {
        // validation for constraint: int
        if (!is_null($ayarRengi) && !(is_int($ayarRengi) || ctype_digit($ayarRengi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ayarRengi, true), gettype($ayarRengi)), __LINE__);
        }
        $this->AyarRengi = $ayarRengi;
        return $this;
    }
    /**
     * Get IsSatisEvraki value
     * @return bool
     */
    public function getIsSatisEvraki()
    {
        return $this->IsSatisEvraki;
    }
    /**
     * Set IsSatisEvraki value
     * @param bool $isSatisEvraki
     * @return \StructType\KEvrakAyar
     */
    public function setIsSatisEvraki($isSatisEvraki = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSatisEvraki) && !is_bool($isSatisEvraki)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSatisEvraki, true), gettype($isSatisEvraki)), __LINE__);
        }
        $this->IsSatisEvraki = $isSatisEvraki;
        return $this;
    }
    /**
     * Get IsTahsilatSubesiSerbest value
     * @return bool
     */
    public function getIsTahsilatSubesiSerbest()
    {
        return $this->IsTahsilatSubesiSerbest;
    }
    /**
     * Set IsTahsilatSubesiSerbest value
     * @param bool $isTahsilatSubesiSerbest
     * @return \StructType\KEvrakAyar
     */
    public function setIsTahsilatSubesiSerbest($isTahsilatSubesiSerbest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTahsilatSubesiSerbest) && !is_bool($isTahsilatSubesiSerbest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTahsilatSubesiSerbest, true), gettype($isTahsilatSubesiSerbest)), __LINE__);
        }
        $this->IsTahsilatSubesiSerbest = $isTahsilatSubesiSerbest;
        return $this;
    }
    /**
     * Get IsSonradanDegistirilebilir value
     * @return bool
     */
    public function getIsSonradanDegistirilebilir()
    {
        return $this->IsSonradanDegistirilebilir;
    }
    /**
     * Set IsSonradanDegistirilebilir value
     * @param bool $isSonradanDegistirilebilir
     * @return \StructType\KEvrakAyar
     */
    public function setIsSonradanDegistirilebilir($isSonradanDegistirilebilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSonradanDegistirilebilir) && !is_bool($isSonradanDegistirilebilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSonradanDegistirilebilir, true), gettype($isSonradanDegistirilebilir)), __LINE__);
        }
        $this->IsSonradanDegistirilebilir = $isSonradanDegistirilebilir;
        return $this;
    }
    /**
     * Get IsHizmetSatirdanSecilecek value
     * @return bool
     */
    public function getIsHizmetSatirdanSecilecek()
    {
        return $this->IsHizmetSatirdanSecilecek;
    }
    /**
     * Set IsHizmetSatirdanSecilecek value
     * @param bool $isHizmetSatirdanSecilecek
     * @return \StructType\KEvrakAyar
     */
    public function setIsHizmetSatirdanSecilecek($isHizmetSatirdanSecilecek = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHizmetSatirdanSecilecek) && !is_bool($isHizmetSatirdanSecilecek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHizmetSatirdanSecilecek, true), gettype($isHizmetSatirdanSecilecek)), __LINE__);
        }
        $this->IsHizmetSatirdanSecilecek = $isHizmetSatirdanSecilecek;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \StructType\KEvrakAyar
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\KEvrakAyar
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Hizmeti value
     * @return \StructType\KHizmetPointer|null
     */
    public function getHizmeti()
    {
        return $this->Hizmeti;
    }
    /**
     * Set Hizmeti value
     * @param \StructType\KHizmetPointer $hizmeti
     * @return \StructType\KEvrakAyar
     */
    public function setHizmeti(\StructType\KHizmetPointer $hizmeti = null)
    {
        $this->Hizmeti = $hizmeti;
        return $this;
    }
}
