<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KAracBakim StructType
 * @subpackage Structs
 */
class KAracBakim extends Entity
{
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The AracHareket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KAracHareketPointer
     */
    public $AracHareket;
    /**
     * Constructor method for KAracBakim
     * @uses KAracBakim::setAciklama()
     * @uses KAracBakim::setAracHareket()
     * @param string $aciklama
     * @param \StructType\KAracHareketPointer $aracHareket
     */
    public function __construct($aciklama = null, \StructType\KAracHareketPointer $aracHareket = null)
    {
        $this
            ->setAciklama($aciklama)
            ->setAracHareket($aracHareket);
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\KAracBakim
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get AracHareket value
     * @return \StructType\KAracHareketPointer|null
     */
    public function getAracHareket()
    {
        return $this->AracHareket;
    }
    /**
     * Set AracHareket value
     * @param \StructType\KAracHareketPointer $aracHareket
     * @return \StructType\KAracBakim
     */
    public function setAracHareket(\StructType\KAracHareketPointer $aracHareket = null)
    {
        $this->AracHareket = $aracHareket;
        return $this;
    }
}
