<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HesapGrubuTanimi StructType
 * @subpackage Structs
 */
class HesapGrubuTanimi extends SerendipEntity
{
    /**
     * The SiraNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SiraNo;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The UstGrup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HesapGrubuTanimiPointer
     */
    public $UstGrup;
    /**
     * The Turu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HesapTuruPointer
     */
    public $Turu;
    /**
     * The KisaKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KisaKodu;
    /**
     * Constructor method for HesapGrubuTanimi
     * @uses HesapGrubuTanimi::setSiraNo()
     * @uses HesapGrubuTanimi::setAdi()
     * @uses HesapGrubuTanimi::setUstGrup()
     * @uses HesapGrubuTanimi::setTuru()
     * @uses HesapGrubuTanimi::setKisaKodu()
     * @param int $siraNo
     * @param string $adi
     * @param \StructType\HesapGrubuTanimiPointer $ustGrup
     * @param \StructType\HesapTuruPointer $turu
     * @param string $kisaKodu
     */
    public function __construct($siraNo = null, $adi = null, \StructType\HesapGrubuTanimiPointer $ustGrup = null, \StructType\HesapTuruPointer $turu = null, $kisaKodu = null)
    {
        $this
            ->setSiraNo($siraNo)
            ->setAdi($adi)
            ->setUstGrup($ustGrup)
            ->setTuru($turu)
            ->setKisaKodu($kisaKodu);
    }
    /**
     * Get SiraNo value
     * @return int
     */
    public function getSiraNo()
    {
        return $this->SiraNo;
    }
    /**
     * Set SiraNo value
     * @param int $siraNo
     * @return \StructType\HesapGrubuTanimi
     */
    public function setSiraNo($siraNo = null)
    {
        // validation for constraint: int
        if (!is_null($siraNo) && !(is_int($siraNo) || ctype_digit($siraNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siraNo, true), gettype($siraNo)), __LINE__);
        }
        $this->SiraNo = $siraNo;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \StructType\HesapGrubuTanimi
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get UstGrup value
     * @return \StructType\HesapGrubuTanimiPointer|null
     */
    public function getUstGrup()
    {
        return $this->UstGrup;
    }
    /**
     * Set UstGrup value
     * @param \StructType\HesapGrubuTanimiPointer $ustGrup
     * @return \StructType\HesapGrubuTanimi
     */
    public function setUstGrup(\StructType\HesapGrubuTanimiPointer $ustGrup = null)
    {
        $this->UstGrup = $ustGrup;
        return $this;
    }
    /**
     * Get Turu value
     * @return \StructType\HesapTuruPointer|null
     */
    public function getTuru()
    {
        return $this->Turu;
    }
    /**
     * Set Turu value
     * @param \StructType\HesapTuruPointer $turu
     * @return \StructType\HesapGrubuTanimi
     */
    public function setTuru(\StructType\HesapTuruPointer $turu = null)
    {
        $this->Turu = $turu;
        return $this;
    }
    /**
     * Get KisaKodu value
     * @return string|null
     */
    public function getKisaKodu()
    {
        return $this->KisaKodu;
    }
    /**
     * Set KisaKodu value
     * @param string $kisaKodu
     * @return \StructType\HesapGrubuTanimi
     */
    public function setKisaKodu($kisaKodu = null)
    {
        // validation for constraint: string
        if (!is_null($kisaKodu) && !is_string($kisaKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kisaKodu, true), gettype($kisaKodu)), __LINE__);
        }
        $this->KisaKodu = $kisaKodu;
        return $this;
    }
}
