<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EIhracatOdemeBilgisi StructType
 * @subpackage Structs
 */
class EIhracatOdemeBilgisi extends SerendipEntity
{
    /**
     * The Varsayilan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Varsayilan;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The EIhracatOdemeSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EIhracatOdemeSekli
     */
    public $EIhracatOdemeSekli;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IBAN;
    /**
     * The HesapNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HesapNo;
    /**
     * The SwiftKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SwiftKodu;
    /**
     * The SubeAdi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubeAdi;
    /**
     * Constructor method for EIhracatOdemeBilgisi
     * @uses EIhracatOdemeBilgisi::setVarsayilan()
     * @uses EIhracatOdemeBilgisi::setKodu()
     * @uses EIhracatOdemeBilgisi::setAdi()
     * @uses EIhracatOdemeBilgisi::setAciklama()
     * @uses EIhracatOdemeBilgisi::setEIhracatOdemeSekli()
     * @uses EIhracatOdemeBilgisi::setIBAN()
     * @uses EIhracatOdemeBilgisi::setHesapNo()
     * @uses EIhracatOdemeBilgisi::setSwiftKodu()
     * @uses EIhracatOdemeBilgisi::setSubeAdi()
     * @param bool $varsayilan
     * @param string $kodu
     * @param string $adi
     * @param string $aciklama
     * @param \StructType\EIhracatOdemeSekli $eIhracatOdemeSekli
     * @param string $iBAN
     * @param string $hesapNo
     * @param string $swiftKodu
     * @param string $subeAdi
     */
    public function __construct($varsayilan = null, $kodu = null, $adi = null, $aciklama = null, \StructType\EIhracatOdemeSekli $eIhracatOdemeSekli = null, $iBAN = null, $hesapNo = null, $swiftKodu = null, $subeAdi = null)
    {
        $this
            ->setVarsayilan($varsayilan)
            ->setKodu($kodu)
            ->setAdi($adi)
            ->setAciklama($aciklama)
            ->setEIhracatOdemeSekli($eIhracatOdemeSekli)
            ->setIBAN($iBAN)
            ->setHesapNo($hesapNo)
            ->setSwiftKodu($swiftKodu)
            ->setSubeAdi($subeAdi);
    }
    /**
     * Get Varsayilan value
     * @return bool
     */
    public function getVarsayilan()
    {
        return $this->Varsayilan;
    }
    /**
     * Set Varsayilan value
     * @param bool $varsayilan
     * @return \StructType\EIhracatOdemeBilgisi
     */
    public function setVarsayilan($varsayilan = null)
    {
        // validation for constraint: boolean
        if (!is_null($varsayilan) && !is_bool($varsayilan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($varsayilan, true), gettype($varsayilan)), __LINE__);
        }
        $this->Varsayilan = $varsayilan;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \StructType\EIhracatOdemeBilgisi
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \StructType\EIhracatOdemeBilgisi
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \StructType\EIhracatOdemeBilgisi
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get EIhracatOdemeSekli value
     * @return \StructType\EIhracatOdemeSekli|null
     */
    public function getEIhracatOdemeSekli()
    {
        return $this->EIhracatOdemeSekli;
    }
    /**
     * Set EIhracatOdemeSekli value
     * @param \StructType\EIhracatOdemeSekli $eIhracatOdemeSekli
     * @return \StructType\EIhracatOdemeBilgisi
     */
    public function setEIhracatOdemeSekli(\StructType\EIhracatOdemeSekli $eIhracatOdemeSekli = null)
    {
        $this->EIhracatOdemeSekli = $eIhracatOdemeSekli;
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return $this->IBAN;
    }
    /**
     * Set IBAN value
     * @param string $iBAN
     * @return \StructType\EIhracatOdemeBilgisi
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        $this->IBAN = $iBAN;
        return $this;
    }
    /**
     * Get HesapNo value
     * @return string|null
     */
    public function getHesapNo()
    {
        return $this->HesapNo;
    }
    /**
     * Set HesapNo value
     * @param string $hesapNo
     * @return \StructType\EIhracatOdemeBilgisi
     */
    public function setHesapNo($hesapNo = null)
    {
        // validation for constraint: string
        if (!is_null($hesapNo) && !is_string($hesapNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hesapNo, true), gettype($hesapNo)), __LINE__);
        }
        $this->HesapNo = $hesapNo;
        return $this;
    }
    /**
     * Get SwiftKodu value
     * @return string|null
     */
    public function getSwiftKodu()
    {
        return $this->SwiftKodu;
    }
    /**
     * Set SwiftKodu value
     * @param string $swiftKodu
     * @return \StructType\EIhracatOdemeBilgisi
     */
    public function setSwiftKodu($swiftKodu = null)
    {
        // validation for constraint: string
        if (!is_null($swiftKodu) && !is_string($swiftKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($swiftKodu, true), gettype($swiftKodu)), __LINE__);
        }
        $this->SwiftKodu = $swiftKodu;
        return $this;
    }
    /**
     * Get SubeAdi value
     * @return string|null
     */
    public function getSubeAdi()
    {
        return $this->SubeAdi;
    }
    /**
     * Set SubeAdi value
     * @param string $subeAdi
     * @return \StructType\EIhracatOdemeBilgisi
     */
    public function setSubeAdi($subeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($subeAdi) && !is_string($subeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subeAdi, true), gettype($subeAdi)), __LINE__);
        }
        $this->SubeAdi = $subeAdi;
        return $this;
    }
}
