<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlimSatisElemani StructType
 * @subpackage Structs
 */
abstract class AlimSatisElemani extends SerendipEntity
{
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Aciklamasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklamasi;
    /**
     * The Kullanici
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kullanici;
    /**
     * The Grubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NesneGrubu
     */
    public $Grubu;
    /**
     * The ElemanIsyeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IsYeriPointer
     */
    public $ElemanIsyeri;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * Constructor method for AlimSatisElemani
     * @uses AlimSatisElemani::setKodu()
     * @uses AlimSatisElemani::setAciklamasi()
     * @uses AlimSatisElemani::setKullanici()
     * @uses AlimSatisElemani::setGrubu()
     * @uses AlimSatisElemani::setElemanIsyeri()
     * @uses AlimSatisElemani::setEmail()
     * @param string $kodu
     * @param string $aciklamasi
     * @param string $kullanici
     * @param \StructType\NesneGrubu $grubu
     * @param \StructType\IsYeriPointer $elemanIsyeri
     * @param string $email
     */
    public function __construct($kodu = null, $aciklamasi = null, $kullanici = null, \StructType\NesneGrubu $grubu = null, \StructType\IsYeriPointer $elemanIsyeri = null, $email = null)
    {
        $this
            ->setKodu($kodu)
            ->setAciklamasi($aciklamasi)
            ->setKullanici($kullanici)
            ->setGrubu($grubu)
            ->setElemanIsyeri($elemanIsyeri)
            ->setEmail($email);
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \StructType\AlimSatisElemani
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Aciklamasi value
     * @return string|null
     */
    public function getAciklamasi()
    {
        return $this->Aciklamasi;
    }
    /**
     * Set Aciklamasi value
     * @param string $aciklamasi
     * @return \StructType\AlimSatisElemani
     */
    public function setAciklamasi($aciklamasi = null)
    {
        // validation for constraint: string
        if (!is_null($aciklamasi) && !is_string($aciklamasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklamasi, true), gettype($aciklamasi)), __LINE__);
        }
        $this->Aciklamasi = $aciklamasi;
        return $this;
    }
    /**
     * Get Kullanici value
     * @return string|null
     */
    public function getKullanici()
    {
        return $this->Kullanici;
    }
    /**
     * Set Kullanici value
     * @param string $kullanici
     * @return \StructType\AlimSatisElemani
     */
    public function setKullanici($kullanici = null)
    {
        // validation for constraint: string
        if (!is_null($kullanici) && !is_string($kullanici)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kullanici, true), gettype($kullanici)), __LINE__);
        }
        $this->Kullanici = $kullanici;
        return $this;
    }
    /**
     * Get Grubu value
     * @return \StructType\NesneGrubu|null
     */
    public function getGrubu()
    {
        return $this->Grubu;
    }
    /**
     * Set Grubu value
     * @param \StructType\NesneGrubu $grubu
     * @return \StructType\AlimSatisElemani
     */
    public function setGrubu(\StructType\NesneGrubu $grubu = null)
    {
        $this->Grubu = $grubu;
        return $this;
    }
    /**
     * Get ElemanIsyeri value
     * @return \StructType\IsYeriPointer|null
     */
    public function getElemanIsyeri()
    {
        return $this->ElemanIsyeri;
    }
    /**
     * Set ElemanIsyeri value
     * @param \StructType\IsYeriPointer $elemanIsyeri
     * @return \StructType\AlimSatisElemani
     */
    public function setElemanIsyeri(\StructType\IsYeriPointer $elemanIsyeri = null)
    {
        $this->ElemanIsyeri = $elemanIsyeri;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\AlimSatisElemani
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
}
